/*----------------------------------------------------
   SORT32.C -- Bubble Sort Benchmark (32-Bit Version)
  ----------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void SortLongs (int iNum)
     {
     int    i, j ;
     long   lBegTime, lEndTime, lTemp ;
     long * plArray ;

     if (NULL == (plArray = calloc (iNum, sizeof (long))))
         {
         printf ("Cannot allocate array for %d items.\n", iNum) ;
         return ;
         }

     for (i = 0 ; i < iNum ; i++)
         plArray [i] = rand () ;

     lBegTime = time (NULL) ;

     for (i = 0     ; i < iNum - 1 ; i++)
     for (j = i + 1 ; j < iNum     ; j++)
         if (plArray [i] > plArray [j])
             {
             lTemp       = plArray [i] ;
             plArray [i] = plArray [j] ;
             plArray [j] = lTemp ;
             }

     lEndTime = time (NULL) ;

     free (plArray) ;

     printf ("Elapsed time for %d items: %ld seconds.\n", iNum,
             lEndTime - lBegTime) ;
     }

int main (void)
     {
     SortLongs (16000) ;
     SortLongs (17000) ;

     return 0 ;
     }
