
//+------------------------------------------------------------------
//
// File: LibMain.c
//
// Contents: DLL Entry and Exit routines.
//
// Synoposis: We do our own heap management. Thus, we have to call
//	      AllocHeap() and DeAllocHeap() defined in memman.cxx
//
// Classes:
//
// Functions: Libmain()
//	      WEP()
//
// History: AlokS   10-25-91
//
//-------------------------------------------------------------------


#include <windows.h>

extern int FAR PASCAL AllocHeap   ( int );
extern int FAR PASCAL DeAllocHeap ( void );

int FAR PASCAL LibMain ( HANDLE	handle,
		     WORD	wDataSeg,
		     WORD	wHeapSize,
		     LPSTR	lpCmdLine
		   )
{
#ifdef never
    _asm int 3;
#endif

    if (wHeapSize==0)
	return 0;

     /*
      * LocalInit sets up a specific area in local heap so that
      * functions such as LocalAlloc will work correctly
      */
    LocalInit (wDataSeg, NULL, (NPSTR) wHeapSize);

    if (wHeapSize!=0)
	UnlockData ( 0 );

    return AllocHeap ( wHeapSize );

}


VOID FAR PASCAL WEP( int nParam)
{
#ifdef never
    _asm int 3;
#endif
    DeAllocHeap ();

    return ;
}
