/****************************************************************************
    FILE: NETIO.H

    PURPOSE: contains function declarations, #defines,
             and constants for netio.c and any program
             using functions exported by netio.c

    History:
                January, 1992       Alok Sinha      Created
****************************************************************************/


#include <direct.h>
#include <dos.h>
#include <stdlib.h>
#include "alloc.h"

// This error can be returned by any netio api calls. It indicates
// that wnetbios.dll NCB table is full of outstanding NCBs.

#define WNETBIOS_ERROR  (80)

BYTE AddName   ( LPSTR lpLocalName, BYTE * pbNameNum);
BYTE DeleteName( LPSTR lpLocalName, BYTE bNameNum );
BYTE CreateASession ( LPSTR lpRemoteName,
                      LPSTR lpLocalName,
                      BYTE * pbLsn);

BYTE Call (	  HWND	hWnd,
		  LPSTR lpLocalName,
		  LPSTR lpRemoteName,
		  BYTE	bRto,
		  BYTE	bSto,
		  BYTE	*pbLsn
	  );

BYTE Listen ( HWND  hWnd,
          LPSTR lpLocalName,
		  LPSTR lpRemoteName,
		  BYTE	bRto,
		  BYTE	bSto,
		  PNCB	*pncbListenPosted
	    );


BYTE Send (	  HWND		hWnd,
		  LPSTR 	lpData,
		  WORD		wDataLen,
		  BYTE		bLsn,
		  unsigned	iMessage,
          SendStatus *peSendState
          );

BYTE Receive (	  HWND		hWnd,
		  LPSTR 	*ppLpData,
		  WORD		wDataLen,
		  BYTE		bLsn,
		  BOOL		fServer
	     );


BYTE Hangup( BYTE bLsn);
BYTE Cancel( PNCB pncbNCBToCancel);


char * R_getcwd( HWND hWnd, BYTE bLsn, char * pszBuffer, int maxlen);

typedef struct find_t FINDT;
BYTE  R_dos_findfirst( HWND hWnd,
                        BYTE bLsn,
                        char * filename,
                        unsigned uAttrib,
                        FINDT *findFileInfo);

BYTE  R_dos_findnext( HWND hWnd,
                      BYTE bLsn,
                      FINDT *findFileInfo);

/* struct to contain find first information */
typedef struct {
    char      chFileName [ MAXFILENAME ] ;
    unsigned  uAttrib;
} FINDFIRST;



/* struct to contain find next information */
typedef struct {
    FINDT FileInfo;
} FINDNEXT;


/* struct to contain getcwd information */
typedef struct {
    char    chBuffer [ _MAX_DIR ] ;
    int     imaxlen;
} GETCWD;


/* A single packet going over net */
typedef struct {
    BYTE  bCommand;         /* Requested Command */
    char  data [1];	    /* variable sized data. Format depends on
			     * command being sent
			     */
}   PACKET;

#define PACKET_SIZE (sizeof(PACKET))

/* Commands  */
#define  R_GETCWD    (01)
#define  R_FINDFIRST (02)
#define  R_FINDNEXT  (03)



/* Time out values */
#define CALL_TIME_OUT	 (double) (60 * 2) // 2 Minutes
#define SEND_TIME_OUT	 (double) (60 * 2) // 2 Minutes
#define RECEIVE_TIME_OUT (double) (60 * 2) // 2 Minutes

#define SEND_NCB_STO	(BYTE) ((2 * 60)* 2)   // 2 Minutes in 1/2 sec intervals
#define RECEIVE_NCB_RTO (BYTE) ((2 * 60)* 2)   // 2 Minutes in 1/2 sec intervals
