;==========================================================================
; PROGRAM: post.asm
;
; PURPOSE: Provide a fixed-in-memory NetBIOS post processing routine
;          as well as a NCB submitting routine.
;
; FUNCTIONS:
;           NetBiosRequest - Allows submitting a NCB
;           PrivPostRoutine- Post processing routine
; HISTORY:
;           January, 1992       Ray Patch       Created
;==========================================================================

;==============================================================================
;	SEGMENT DEFINTIONS
;==============================================================================

_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS

_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS

CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS

_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS

DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME	DS: DGROUP
	ASSUME  SS: NOTHING


.286		; 80286 and above ONLY.

EXTRN _NcbTablePtr: DWORD
EXTRN _TableEntriesUsed: WORD
EXTRN  PostMessage:FAR
EXTRN NETBIOSCALL: FAR

DEFAULT_MAX_NCBS	EQU 12
			
ENTRY struc
    pNcbOff         dw  ?
    pNcbSeg         dw  ?
    hWnd            dw  ?
    iMessage	    dw	?
ENTRY ends

NCB struc
    ncb_command	    db	?
    ncb_retcode	    db	?
    ncb_lsn         db  ?
    ncb_num         db  ?
    ncb_buffer	    dd	?
    ncb_length	    dw	?
    ncb_callname    db	16 dup(?)
    ncb_name	    db	16 dup(?)
    ncb_rto         db  ?
    ncb_sto         db  ?
    ncb_post	    dd	?
    ncb_lana_num    db	?
    ncb_cmd_cplt    db	?
    ncb_reserved    db	14 dup(?)
NCB ends

_TEXT SEGMENT WORD PUBLIC 'CODE'
    ASSUME CS:_TEXT, DS:DGROUP

PUBLIC _PrivPostRoutine
PUBLIC  NetBiosRequest

_PrivPostRoutine PROC FAR
    ;;;	    ES:BX = NCB address.

    push    ds
    push    ax
    push    cx
    push    si

    mov	    ax, DGROUP
    mov	    ds, ax
    push    ax					; save DS

    ;;;	    set DS:SI equal to the NCB table.
    ;;;	    set CX equal to the table size.

    lds	    si, DWORD PTR [_NcbTablePtr]
    mov	    cx, DEFAULT_MAX_NCBS
    ;======================================================================
    ;	main search loop.
    ;======================================================================

_PrivPostRoutine_Loop:
    ;;;	    Check the NCB offsets first.

    cmp	    bx, WORD PTR [si].pNcbOff		; bx = offset of NCB received.
    jne     _PrivPostRoutine_NextEntry

    ;;;	    Now check the segments

    mov	    ax, es				; ax = segment of NCB received.
    cmp	    ax, WORD PTR [si].pNcbSeg
    je	    _PrivPostRoutine_PostMessage
		
_PrivPostRoutine_NextEntry:
    ;;;	    move pointer to next entry in the NCB table and continue if CX is not zero.

    add	    si, SIZE ENTRY
    loop    _PrivPostRoutine_loop

    pop     ds                      ; DS = DGROUP
    jmp   short  _Not_In_Table

    ;======================================================================
    ;	PostMessage(hWnd, iMessage, ncb_command, pNcb);
    ;======================================================================

_PrivPostRoutine_PostMessage:

    mov	    al, BYTE PTR es:[bx].ncb_command	; AL = NCB command.
    sub     ah, ah                              ; AX = NCB command.
	
    push    [si].hWnd				; push window handle
    push    [si].iMessage			; push iMessage
    push    ax                      ; push command code
    push    [si].pNcbSeg			; push NCB pointer
    push    [si].pNcbOff
    call    FAR PTR PostMessage

    ;;;		Now clear the NCB pointer field of the table to 0.

    xor	    ax, ax
    mov	    [si].pNcbSeg, ax			; Mark this entry in the table
    mov	    [si].pNcbOff, ax			; as free.

    pop     ds                          ; DS = DGROUP
    dec	    _TableEntriesUsed			; --TableEntriesUsed;

_Not_In_Table:
    ;;;	    Restore the registers and exit.


    pop	    si
    pop	    cx
    pop	    ax
    pop	    ds

    iret					; return to NetBIOS.
_PrivPostRoutine ENDP

;==========================================================================
; WORD _far _Pascal NetBiosRequest(PNCB pNcb);
;==========================================================================

NetBiosRequest PROC FAR
    enter   0, 0
    push    di
    push    si

    les     bx, DWORD PTR [bp+6]
    call    FAR PTR NETBIOSCALL
    sub     ah, ah

    ;;;	    AX = the NetBIOS return code.
    xor     ah, ah
    mov     al, BYTE PTR es:[bx+1] ; return the NCB return code

    pop si
    pop di

    leave
    ret

NetBiosRequest ENDP

_TEXT ENDS
     END
