/****************************************************************************
    FILE: STATE.H

    EXPLANATION:
        1. Contains possible Client and Server Finite State Machine
           state names.
        2. Contains possible CallStatus/SendStatus/ReceiveStatus values.

    History:
        January, 1992       AlokS       Created

****************************************************************************/


typedef enum _ClientFSM { C_UNINITIALIZED, C_INITIALIZED, C_CALLING,
                          C_CONNECTED, C_SENDING, C_SENT, C_RECEIVING,
                          C_RECEIVED
                        } ClientFSM;


typedef enum _ServerFSM { S_UNINITIALIZED, S_INITIALIZED, S_LISTENING,
                          S_CONNECTED, S_RECEIVING, S_RECEIVED,
                          S_SENDING, S_SENT, S_ENDING
                        } ServerFSM;



typedef enum _CallStatus { CALL_START, CALL_CMPLT, CALL_ERROR } CallStatus;

typedef enum _SendStatus { SEND_START, SEND_CMPLT, SEND_ERROR } SendStatus;

typedef enum _ReceiveStatus { RECEIVE_START, RECEIVE_CMPLT,
                              RECEIVE_ERROR } ReceiveStatus;
