/*
      Copyright 1991 by David Thielen, All Rights Reserved.

      This code example is from a commercial product and has restricted
      rights.  This code, or any code derived from this code may be
      incorporated into any programs with the following restrictions;
      1) It cannot be sold as source code, and 2) It cannot be sold in a
      product which provides this code as an API.
*/


#include "file_io.h"


// First we truncate the file to 0 length.  If the delete fails (we
// have the wrong name), at least we won't be taking up tons of disk
// space.

// ALSO - DOS will not need to write any dirty buffers if we truncate
// the file first.  If we close first, it will write the dirty buffers
// and then close.

// Once the file is closed, we need to delete it.

unsigned FileCloseTemp (int hFil,BYTE const *pFile)
{
   unsigned uRtn, uTmp;


   // set to 0 length
   FileSetSize (hFil, 0L);

   // Close it
   uRtn = FileClose (hFil);

   // Delete it
   if ((uTmp = FileDelete (pFile)) != 0)
      return (uTmp);

   return (uRtn);
}
