/*
      Copyright 1991 by David Thielen, All Rights Reserved.

      This code example is from a commercial product and has restricted
      rights.  This code, or any code derived from this code may be
      incorporated into any programs with the following restrictions;
      1) It cannot be sold as source code, and 2) It cannot be sold in a
      product which provides this code as an API.
*/


#include "file_io.h"


// Keep in mind that a disk caching program may ignore the below so
// that while the file is flushed from DOS, it may still be in the
// buffers of the cache.  Unfortunately, there is no way around this.

// fOpenCommit is true if the file was opened with the commit bit set.

unsigned FileCommit (int hFil,int fOpenCommit)
{
int hTmp;
unsigned uRtn=0;

   // If we opened with commit & we are on DOS 4.0+, we don't need to
   // do anything.
   // OS/2 is DOS version 10 - we treat that like DOS 3.3
   if ((fOpenCommit) && (DosMajVer >= 4) && (DosMajVer != 10))
      return (0);

   // If we are on version 3.3+, we can use file commit
   if ((DosMajVer > 3) || ((DosMajVer == 3) && (DosMinVer >= 3)))
      {
      _asm
         {
         mov      ah, 68h
         mov      bx, [hFil]
         int      21h
         jnc      Ok
         mov      [uRtn], ax
Ok:
         }
      return (uRtn);
      }

   // We now have 3 options.  The first is to create a dup handle & then
   // close it.  However, this will fail if there are no available
   // handles.  The second option is to close the file & then re-open it
   // but that requires we store the file name - which we will only need
   // for DOS < 3.3 AND no available handles.  Finally, we can reset the
   // disk which will flush all buffers but won't update the directory
   // entry (which means the size & date of the file MAY be wrong).

   // If you are VERY concerned about this, there are 3 changes you can
   // make in this code.  1) You can require DOS 3.3 or greater.  2) You
   // can store the FULL name of the file.  3) You could close handle 0
   // (which is generally CON) and then perform the dup/close, then re-open
   // CON.  Be careful on the final choice that you re-open whatever was
   // truly on handle 0 - which in the case of re-directed I/O, may be
   // a file.

   // Lets try a dup
   if ((hTmp = FileDup (hFil)) >= 0)
      {
      // ok close the dup & return
      uRtn = FileClose (hTmp);

      return (uRtn);
      }

   // We're fucked - all we can do is flush the buffers
   // The directory entry WON'T be updated (which is only a problem
   // if the file has grown since it was last closed/flushed).
   // If you are using a file for transaction processing & it has a
   // maximum size that's reasonable, open the file, write 0 bytes at
   // the limit to size it, close & re-open it & then the below flush
   // will always be sufficient.
   _asm
      {
      mov      ah, 0Dh
      int      21h
      }

   return (0);
}

