/*
      Copyright 1991 by David Thielen, All Rights Reserved.

      This code example is from a commercial product and has restricted
      rights.  This code, or any code derived from this code may be
      incorporated into any programs with the following restrictions;
      1) It cannot be sold as source code, and 2) It cannot be sold in a
      product which provides this code as an API.
*/


#include "file_io.h"

static unsigned _Write (int hFil, void const *pBuf, unsigned uNum,
                        unsigned *puErr);


// These are all the 'other' file handle calls.  They are included here
// for 2 reasons;
// 1) Most c run-time libraries don't go direct to the DOS calls so you
//    can't intermix FileOpen with a write.
// 2) The other files can use these calls.

// Because these calls are so straightforward, comments are minimal.


unsigned FileClose (int hFil)
{
unsigned uRtn;

   _asm
      {
      mov      [uRtn], 0
      mov      ah, 3Eh
      mov      bx, [hFil]
      int      21h                  ; close the file
      jnc      l1
      mov      [uRtn], ax
l1:
      }

   return (uRtn);
}


unsigned FileDelete (BYTE const *pFile)
{
unsigned uRtn;

   _asm
      {
      mov      [uRtn], 0
      mov      ah, 41h
      mov      dx, [pFile]
      int      21h                  ; delete the file
      jnc      Ok
      mov      [uRtn], ax
Ok:
      }

   return (uRtn);
}

int FileDup (int hFil)
{
int hRtn;

   _asm
      {
      mov      [hRtn], -1
      mov      ah, 45h
      mov      bx, [hFil]
      int      21h
      jc    l1
      mov      [hRtn], ax
l1:
      }

   return (hRtn);
}

unsigned long FileGetSize (int hFil)
{
long lRtn;

   _asm
      {
      mov      word ptr [lRtn], -1        ; in case of error
      mov      word ptr [lRtn+2], -1

      ; Save the offset
      mov      ax, 4201h
      mov      bx, [hFil]
      xor      cx, cx
      mov      dx, cx
      int      21h                  ; Get current position
      jc    Err2
      push  cx
      push  dx

      ; Get the length
      mov      ax, 4202h
      xor      cx, cx
      mov      dx, cx
      int      21h                  ; Get length
      jc    Err1
      mov      word ptr [lRtn], ax
      mov      word ptr [lRtn+2], dx

Err1:    ; Restore old position
      mov      ax, 4200h
      pop      dx
      pop      cx
      int      21h                  ; Restore current position

Err2:
      }

   return (lRtn);
}

unsigned FileRead (int hFil, void *pBuf, unsigned uNum)
{
unsigned uRtn;

   // File I/O calls are expensive.  Therefore, we handle 0 FAST
   if (! uNum)
      return (0);

   _asm
      {
      mov      [uRtn], 0
      mov      ah, 3Fh
      mov      bx, [hFil]
      mov      cx, [uNum]
      mov      dx, [pBuf]
      int      21h
      jc    Err
      mov      [uRtn], ax
Err:
      }

   return (uRtn);
}

unsigned FileSeek (int hFil, unsigned long ulOffset)
{
unsigned uRtn=0;

   _asm
      {
      mov      ax, 4200h
      mov      bx, [hFil]
      mov      dx, word ptr [ulOffset]
      mov      cx, word ptr [ulOffset+2]
      int      21h                  ; seek
      jnc      l1
      mov      [uRtn], ax
l1:
      }

   return (uRtn);
}

unsigned FileSeekRead (int hFil, unsigned long ulOffset, void *pBuf,
                       unsigned uNum)
{

   if (FileSeek (hFil, ulOffset))
      return (0);

   return (FileRead (hFil, pBuf, uNum));
}

unsigned FileSeekWrite (int hFil, unsigned long ulOffset, void const *pBuf,
                        unsigned uNum)
{

   if (FileSeek (hFil, ulOffset))
      return (0);

   return (FileWrite (hFil, pBuf, uNum));
}


// If we are extending the file - write one byte to ensure it extends
// A write past the end of the disk doesn't error out - it just returns
// 0 bytes written.

unsigned FileSetSize (int hFil, unsigned long ulSize)
{
unsigned uRtn, uNum;

   if (FileGetSize (hFil) < ulSize)
      {
      ulSize--;
      uNum = 1;
      }
   else
      uNum = 0;

   if ((uRtn = FileSeek (hFil, ulSize)) != 0)
      return (uRtn);

   if (_Write (hFil, &uRtn, uNum, &uRtn) != uNum)
      {
      if (uRtn)
         return (uRtn);
      return (0x1E);
      }
   return (uRtn);
}

unsigned FileWrite (int hFil, void const *pBuf, unsigned uNum)
{
unsigned uErr;

   // A write of 0 bytes sets a file size.  Use SetSize above to do this
   if (! uNum)
      return (0);

   return (_Write (hFil, pBuf, uNum, &uErr));
}

static unsigned _Write (int hFil, void const *pBuf, unsigned uNum,
                        unsigned *puErr)
{
unsigned uRtn, uErr;

   _asm
      {
      mov      [uRtn], 0
      mov      [uErr], 0
      mov      ah, 40h
      mov      bx, [hFil]
      mov      cx, [uNum]
      mov      dx, [pBuf]
      int      21h
      jc    Err
      mov      [uRtn], ax
      jmp      Ok

Err:
      mov      [uErr], ax

Ok:
      }

   *puErr = uErr;
   return (uRtn);
}
