
extern unsigned char DosMajVer, DosMinVer;

typedef unsigned char  BYTE;
typedef unsigned char  FLAG;

// O_COMMIT only works in DOS 4.0 & up.  For commit on pre DOS 4 call
// FileCommit.

// O_CREATE will create a file ONLY if it doesn't exist.  To force a
// create, use "O_CREATE | O_OPEN | O_TRUNC".

// If O_TEMP is set, the file name is the directory to create the file in.
// Will copy the final name into pFile - make sure its long enough (extra
// 12 bytes).  If O_TEMP is set, O_OPEN & O_CREATE are ignored.

// At least one of O_READ and O_WRITE must be set.

// If you do NOT use S_DENY_READ and/or S_DENY_WRITE - the file will be
// opened in DENY_NONE, NOT compatibility mode.  For pre DOS 4, to get the
// sharing set on a create, the file will be created, closed, and then
// opened.


#define     O_OPEN       0x0001       // Open the file
#define     O_CREATE     0x0002       // Create the file if doesn't exist
#define     O_TEMP       0x0004       // Open a temporary file

#define     O_READ       0x0010       // Can read from the file
#define     O_WRITE      0x0020       // Can write to the file

#define     O_APPEND     0x0100       // seek to end of file
#define     O_TRUNC      0x0200       // set file to 0 length
#define     O_COMMIT     0x0400       // set file to write-through

#define     S_DENY_READ  0x1000       // lock out other reads
#define     S_DENY_WRITE 0x2000       // lock out other writes
#define     S_DENY_CHILD 0x4000       // don't pass handle to child

#define     A_READ_ONLY  0x01        // Create file attributes
#define     A_HIDDEN     0x02
#define     A_SYSTEM     0x04
#define     A_ARCHIVE    0x20


#ifdef   DEBUG

void  DebugPrintf (char const *, ...);

#endif

unsigned FileClose(int hFil);
unsigned FileCloseTemp(int hFil,BYTE const *pFile);
unsigned FileCommit(int hFil,int fOpenCommit);
unsigned FileDelete(BYTE const *pFile);
int            FileDup(int hFil);
unsigned long FileGetSize(int hFil);
int FileOpen(BYTE *pFile,unsigned uMode,unsigned uAtr,
             unsigned *puErr);
int FileOpenTemp(BYTE *pFile,unsigned long lNum);
unsigned FileRead(int hFil,void *pBuf,unsigned uNum);
unsigned FileSeek(int hFil,unsigned long ulOffset);
unsigned FileSeekRead(int hFil,unsigned long ulOffset,void *pBuf,unsigned uNum);
unsigned FileSeekWrite(int hFil,unsigned long ulOffset,void const *pBuf,unsigned uNum);
unsigned FileSetSize(int hFil,unsigned long ulSize);
unsigned FileTrueName(BYTE const *pFile,BYTE *pTrue);
unsigned FileWrite(int hFil,void const *pBuf,unsigned uNum);
