/*
      Copyright 1991 by David Thielen, All Rights Reserved.

      This code example is from a commercial product and has restricted
      rights.  This code, or any code derived from this code may be
      incorporated into any programs with the following restrictions;
      1) It cannot be sold as source code, and 2) It cannot be sold in a
      product which provides this code as an API.
*/


#include "file_io.h"
#include "stdlib.h"
#include "string.h"


// pFile is used to return the name of the file created (for when it
// is closed & deleted - nothing is passed in in it.  It should be at
// least 128 bytes long.
// lNum is used to initially size the file to insure there is enough
// room on the temp drive.

// The env variables used to determine the file directory are in order;
// TempPath, Temp, & Tmp.  The TempPath var can have ';' between choices
// just like path.  If none of those work, it will use the default
// directory.

// To use a directory from one of the environment vars above, not only
// must the dir exist but there must be enough room on the disk (lNum).

#define     MAX_PATH  114
#define     NUM_ENV    3
BYTE *aEnv[NUM_ENV] = {"TEMPPATH", "TEMP", "TMP"};
BYTE sDef[] = ".";

int FileOpenTemp (BYTE *pFile,unsigned long ulNum)
{
int iNum, iLen, hRtn;
unsigned uErr;
BYTE *pEnv, **pName, *pTmp;
BYTE sTemp[128];

#ifdef   DEBUG
   memset (pFile, '$', 128);
#endif

   // We walk through, once for each env var and once for the default
   // directory.
   for (iNum=0, pName=aEnv; iNum<=NUM_ENV; iNum++, pName++)
      {

      // If we are on our last run, we use ".\" as the env var.
      if (iNum < NUM_ENV)
         pEnv = getenv (*pName);        // Env var
      else
         pEnv = sDef;             // default directory

      // If we got something, we try each directory in the path
      if (pEnv)
         while (*pEnv)             // Try a directory
            {

            // Build up the directory
            // advance pEnv to next dir
            strncpy (pFile, pEnv, MAX_PATH);
            *(pFile + MAX_PATH) = 0;
            if ((pTmp = strchr (pEnv, ';')) == NULL)
               pEnv = NULL;
            else
               {
               if ((iLen = pTmp - pEnv) < MAX_PATH)
                  *(pFile + iLen) = 0;
               pEnv = pTmp + 1;
               }

            // lets try opening it.
            // OpenFile will handle a missing '\' at the end of the string
            if ((hRtn = FileOpen (pFile, O_READ | O_WRITE | O_TEMP |
                           S_DENY_READ | S_DENY_WRITE, 0, &uErr)) >= 0)
               {

               // If we have a length - try to make the file that long
               if (ulNum)
                  {
                  uErr = FileSetSize (hRtn, ulNum);
                  FileSeek (hRtn, 0L);
                  }

               // We made a file of the length we wanted - return it
               // We return its true name so when its time to delete, we
               // can find it even if it has been re-mapped.
               if (! uErr)
                  {
                  strcpy (sTemp, pFile);
                  FileTrueName (sTemp, pFile);
                  return (hRtn);
                  }

               // We had an error - close & delete the file
               FileCloseTemp (hRtn, pFile);

               }  // end if (OpenFile (...))
            }     // while (*pEnv)
      }           // for (...)
}
