

unsigned char     DosMajVer = 5;
unsigned char     DosMinVer = 0;

#include "file_io.h"
#include "stdlib.h"
#include "stdio.h"
#include "conio.h"
#include "string.h"

void SetDosVer (void);
void TestTrueName (void);
void TestOpen (void);
void TestClose (void);
void TestOpenTemp (void);
void TestCloseTemp (void);
void TestCommit (void);
void TestDelete (void);
void TestDup (void);
void TestGetSize (void);
void TestRead (void);
void TestSeek (void);
void TestSetSize (void);
void TestWrite (void);

#define     MAX_FILES   60

BYTE asName [MAX_FILES][130];

void main (void)
{
int iCmd, iFile;

   do
      {
      printf ("\nOpen Files:\n");
      for (iFile=0; iFile<MAX_FILES; iFile++)
         if (asName[iFile][0])
            printf ("%d\t%s\n", iFile, asName[iFile]);

      printf ("\nDOS Version %d.%d\n", DosMajVer, DosMinVer);
      printf ("A\tSet DOS Version Number\tH\tTest FileDelete\n");
      printf ("B\tTest FileTrueName\tI\tTest FileDup\n");
      printf ("C\tTest FileOpen\t\tJ\tTest FileGetSize\n");
      printf ("D\tTest FileClose\t\tK\tTest FileRead\n");
      printf ("E\tTest FileOpenTemp\tL\tTest FileSeek\n");
      printf ("F\tTest FileCloseTemp\tM\tTest FileSetSize\n");
      printf ("G\tTest FileCommit\t\tN\tTest FileWrite\n");

      printf ("X\tExit\n");
      iCmd = toupper (getch ());
      printf ("\n");

      switch (iCmd)
         {
         case 'A' :
            SetDosVer ();
            break;
         case 'B' :
            TestTrueName ();
            break;

         case 'C' :
            TestOpen ();
            break;
         case 'D' :
            TestClose ();
            break;
         case 'E' :
            TestOpenTemp ();
            break;
         case 'F' :
            TestCloseTemp ();
            break;

         case 'G' :
            TestCommit ();
            break;
         case 'H' :
            TestDelete ();
            break;
         case 'I' :
            TestDup ();
            break;

         case 'J' :
            TestGetSize ();
            break;
         case 'K' :
            TestRead ();
            break;
         case 'L' :
            TestSeek ();
            break;
         case 'M' :
            TestSetSize ();
            break;
         case 'N' :
            TestWrite ();
            break;

         case 'X' :
            break;
         default :
            putch (7);
            break;
         }

      }
   while (iCmd != 'X');
   printf ("\nAll Done\n");
}

void SetDosVer (void)
{

   printf ("Major Version: ");
   scanf ("%d", &DosMajVer);
   printf ("Minor Version: ");
   scanf ("%d", &DosMinVer);
}

void TestTrueName (void)
{
unsigned uRtn;
BYTE sName[130], sTrue[130];

   memset (sTrue, '$', 128);
   sTrue[128] = 0;

   printf ("Enter file name: ");
   gets (sName);

   uRtn = FileTrueName (sName, sTrue);

   printf ("File: {%s} is {%s} = 0x%X\n", sName, sTrue, uRtn);

}

void TestOpen (void)
{
int iRtn;
unsigned uMode, uAtr=0, uErr=-1;
BYTE sName[128];

   printf ("Enter file name: ");
   sName[0] = 0;
   while (! sName[0])
      gets (sName);

   printf ("Mode: ");
   scanf ("%x", &uMode);

   if (uMode & (O_CREATE | O_TEMP))
      {
      printf ("Atr: ");
      scanf ("%x", &uAtr);
      }

   iRtn = FileOpen (sName, uMode, uAtr, &uErr);
   printf ("FileOpen (%s, 0x%X, 0x%X, 0x%X) = %d\n", sName, uMode, uAtr,
           uErr, iRtn);

   if ((iRtn >= 0) && (iRtn < MAX_FILES))
      {
      FileTrueName (sName, asName[iRtn]);
      asName[iRtn][128] = 0;
      }

}

void TestClose (void)
{
int iHdl;
unsigned uRtn;
BYTE *pBuf;

   printf ("File Handle: ");
   scanf ("%d", &iHdl);

   uRtn = FileClose (iHdl);
   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      pBuf = asName[iHdl];
   else
      pBuf = "none";
   printf ("FileClose (%d {%s}) = 0x%X\n", iHdl, pBuf, uRtn);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      asName[iHdl][0] = 0;
}

void TestOpenTemp (void)
{
int iRtn;
long lSize;
BYTE sName[128];

   printf ("Length: ");
   scanf ("%ld", &lSize);

   iRtn = FileOpenTemp (sName, lSize);
   printf ("FileOpenTemp (%s, %ld) = %d\n", sName, lSize, iRtn);

   if ((iRtn >= 0) && (iRtn < MAX_FILES))
      {
      strncpy (asName[iRtn], sName, 128);
      asName[iRtn][128] = 0;
      }
}

void TestCloseTemp (void)
{
int iHdl;
unsigned uRtn;
BYTE *pBuf;

   printf ("File Handle: ");
   scanf ("%d", &iHdl);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      pBuf = asName[iHdl];
   else
      pBuf = "none";
   uRtn = FileCloseTemp (iHdl, pBuf);
   printf ("FileCloseTemp (%d, %s) = 0x%X\n", iHdl, pBuf, uRtn);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      asName[iHdl][0] = 0;
}

void TestCommit (void)
{
int iHdl;
unsigned uRtn;
BYTE *pBuf;

   printf ("File Handle: ");
   scanf ("%d", &iHdl);

   uRtn = FileCommit (iHdl, 0);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      pBuf = asName[iHdl];
   else
      pBuf = "none";
   printf ("FileCommit (%d {%s}) = 0x%X\n", iHdl, pBuf, uRtn);
}

void TestDelete (void)
{
unsigned uRtn;
BYTE sName[130];

   printf ("File: ");
   gets (sName);

   uRtn = FileDelete (sName);

   printf ("FileDelete (%s) = 0x%X\n", sName, uRtn);
}

void TestDup (void)
{
int iHdl, iDup;
BYTE *pBuf;

   printf ("File Handle: ");
   scanf ("%d", &iHdl);

   iDup = FileDup (iHdl);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      pBuf = asName[iHdl];
   else
      pBuf = "none";
   printf ("FileDup (%d {%s}) = %d\n", iHdl, pBuf, iDup);

   if ((iDup >= 0) && (iDup < MAX_FILES))
      strcpy (asName[iDup], pBuf);
}

void TestGetSize (void)
{
int iHdl;
long lSize;
BYTE *pBuf;

   printf ("File Handle: ");
   scanf ("%d", &iHdl);

   lSize = FileGetSize (iHdl);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      pBuf = asName[iHdl];
   else
      pBuf = "none";
   printf ("FileGetSize (%d {%s}) = %ld\n", iHdl, pBuf, lSize);
}

void TestRead (void)
{



}

void TestSeek (void)
{



}

void TestSetSize (void)
{
int iHdl;
unsigned uRtn;
long lSize;
BYTE *pBuf;

   printf ("File Handle: ");
   scanf ("%d", &iHdl);

   printf ("File Size: ");
   scanf ("%ld", &lSize);

   uRtn = FileSetSize (iHdl, lSize);

   if ((iHdl >= 0) && (iHdl < MAX_FILES))
      pBuf = asName[iHdl];
   else
      pBuf = "none";
   printf ("FileSetSize (%d {%s}, %ld) = 0x%X\n", iHdl, pBuf, lSize, uRtn);
}

void TestWrite (void)
{



}

