/*
      Copyright 1991 by David Thielen, All Rights Reserved.

      This code example is from a commercial product and has restricted
      rights.  This code, or any code derived from this code may be
      incorporated into any programs with the following restrictions;
      1) It cannot be sold as source code, and 2) It cannot be sold in a
      product which provides this code as an API.
*/


#include "file_io.h"
#include "string.h"

// Convert the file name in pFile to the true name (elim append, join, &
// subst) and put it in pTrue.  On an error, will return the passed in
// name.

unsigned FileTrueName (BYTE const *pFile,BYTE *pTrue)
{
unsigned uRtn;

#ifdef   DEBUG
   if ((! pFile) || (! pTrue) || (! *pFile))
      DebugPrintf ("TrueName (%s(%X), (%X))\n", pFile, pFile, pTrue);
   memset (pTrue, '$', 128);
#endif

   // Before DOS 3 - can't do it.
   // Return the passed in name so you have something
   if (DosMajVer < 3)
      {
      strcpy (pTrue, pFile);
      return (-1);
      }

   *pTrue = 0;
   _asm
      {
      mov      ax, 6000h
      mov      si, [pFile]
      mov      di, [pTrue]
      push  ds
      pop      es
      int      21h                  // Convert file name
      mov      [uRtn], ax
      jc    dne
      mov      [uRtn], 0
dne:
      }

   if (uRtn)
      strcpy (pTrue, pFile);
   return (uRtn);
}


