/*-------------------------------------------
   TRANSFRM.C -- Win32 Matrix Transform Demo
                 (c) Charles Petzold, 1992
  -------------------------------------------*/

#include <windows.h>
#include <math.h>

#define TWOPI (2 * 3.14159)

LONG APIENTRY WndProc (HWND, UINT, DWORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     static char szAppName[] = "Transfrm" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szAppName, "Matrix Transform Demo",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

LONG APIENTRY WndProc (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static short cxClient, cyClient ;
     HDC          hdc ;
     int          i ;
     PAINTSTRUCT  ps ;
     XFORM        xform ;

     switch (message)
          {
          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
	       hdc = BeginPaint (hwnd, &ps) ;

               SelectObject (hdc, GetStockObject (NULL_BRUSH)) ;

               for (i = 0 ; i < 180 ; i += 18)
                    {
                    xform.eM11 = (FLOAT)   cos (i * TWOPI / 360) ;
                    xform.eM12 = (FLOAT) - sin (i * TWOPI / 360) ;
                    xform.eM21 = (FLOAT)   sin (i * TWOPI / 360) ;
                    xform.eM22 = (FLOAT)   cos (i * TWOPI / 360) ;
                    xform.eDx  = (FLOAT) (cxClient / 2) ;
                    xform.eDy  = (FLOAT) (cyClient / 2) ;

                    SetWorldTransform (hdc, &xform) ;

                    Ellipse (hdc, -cxClient / 4, -cyClient / 4,
                                   cxClient / 4,  cyClient / 4) ;
                    }

	       EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
