// pump_c7.c

#include <windows.h>
#include <toolhelp.h>
#include "resource.h"



long      m_lMsgCount;
TIMERINFO m_ti;
DWORD     m_dwStartTime,
          m_dwStopTime,
          m_dwCalibrationTime;


long FAR PASCAL WndProc (HWND, unsigned, UINT, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName [] = "Pump Demo w/o MFC" ;
     HWND        hWnd ;
     WNDCLASS    wc ;

     if (!hPrevInstance)
          {
          wc.style         = CS_HREDRAW | CS_VREDRAW ;
          wc.lpfnWndProc   = WndProc ;
          wc.cbClsExtra    = 0 ;
          wc.cbWndExtra    = 0 ;
          wc.hInstance     = hInstance ;
          wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wc.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wc.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wc.lpszMenuName  = "MainMenu";
          wc.lpszClassName = szAppName ;

          if (!RegisterClass (&wc)) return FALSE ;
          }

     hWnd = CreateWindow (szAppName,         /* window class name       */
                    "Message Pump w/o MFC",  /* window caption          */
                    WS_OVERLAPPEDWINDOW,     /* window style            */
                    CW_USEDEFAULT,           /* initial x position      */
                    0,                       /* initial y position      */
                    CW_USEDEFAULT,           /* initial x size          */
                    0,                       /* initial y size          */
                    NULL,                    /* parent window handle    */
                    NULL,                    /* window menu handle      */
                    hInstance,               /* program instance handle */
                    NULL) ;                  /* create parameters       */

     ShowWindow   (hWnd, nCmdShow) ;
     UpdateWindow (hWnd) ;

         MSG msg;

         while (GetMessage (&msg, NULL, 0, 0))
         {
         TranslateMessage (&msg) ;
         DispatchMessage  (&msg) ;
         }

     return msg.wParam ;
     }


long FAR PASCAL WndProc (HWND hwnd, unsigned iMessage,
                         UINT wParam, LONG lParam)
     {
     switch (iMessage)
          {
          case WM_COMMAND:
               {
               switch (wParam)
                    {
                    case IDM_STARTPOSTMESSAGE:
                         {
                         SetWindowText (hwnd, "Calibrating Message Pump...");
                         m_lMsgCount   = 0;
                         m_ti.dwSize = sizeof (TIMERINFO);
                         TimerCount (&m_ti);
                         m_dwStartTime = m_ti.dwmsSinceStart;

                         if (m_lMsgCount < 10000)
                           {
                           m_lMsgCount++;
                           }

                         TimerCount (&m_ti);
                         m_dwStopTime = m_ti.dwmsSinceStart;
                         m_dwCalibrationTime = m_dwStopTime - m_dwStartTime;

                         //   Now Start message pump
                         //
                         SetWindowText (hwnd,
                                        "Posting 10,000 messages thru pump...");
                         m_lMsgCount   = 0;
                         TimerCount (&m_ti);
                         m_dwStartTime = m_ti.dwmsSinceStart;
                         PostMessage (hwnd, WM_USER, 0, 0);
                         }
                        return 0;

                    case IDM_STARTSENDMESSAGE:
                         {
                         SetWindowText (hwnd, "Calibrating Message Pump...");
                         m_lMsgCount = 0;
                         m_ti.dwSize = sizeof (TIMERINFO);
                         TimerCount (&m_ti);
                         m_dwStartTime = m_ti.dwmsSinceStart;

                         if (m_lMsgCount < 10000)
                           {
                           m_lMsgCount++;
                           }

                         TimerCount (&m_ti);
                         m_dwStopTime = m_ti.dwmsSinceStart;
                         m_dwCalibrationTime = m_dwStopTime - m_dwStartTime;

                         //   Now Start message pump
                         //
                         SetWindowText (hwnd,
                                        "Sending 10,000 messages thru pump...");
                         m_lMsgCount   = 0;
                         TimerCount (&m_ti);
                         m_dwStartTime = m_ti.dwmsSinceStart;

                         while (m_lMsgCount < 10000)
                           {
                           SendMessage (hwnd, WM_USER+1, 0, 0);
                           }

                         }
                        return 0;
                    }
               }
               return DefWindowProc (hwnd, iMessage, wParam, lParam) ;

          case WM_USER:
               {
               char string [40];

               m_lMsgCount++;

               if (m_lMsgCount < 10000)
                 {
                 // Keep message pump going
                 //
                 PostMessage (hwnd, WM_USER, 0, 0L);
                 }

               else
                 {
                 // Stop message pump & display msg rate
                 //
                 TimerCount (&m_ti);
                 m_dwStopTime = m_ti.dwmsSinceStart;

                 DWORD dwElapsedTime=(m_dwStopTime-m_dwStartTime) -
                                      m_dwCalibrationTime;
                 wsprintf(string, "Posted Msgs per second = %ld",
                         (LONG) (1000. * ((double)m_lMsgCount/dwElapsedTime)));
                 SetWindowText (hwnd, string);
                 }
               }
              return 0;

           case WM_USER+1:
               {
               char string [40];

               m_lMsgCount++;

               if (m_lMsgCount >= 10000)
                 {
                 // Stop message pump & display msg rate
                 //
                 TimerCount (&m_ti);
                 m_dwStopTime = m_ti.dwmsSinceStart;

                 DWORD dwElapsedTime = (m_dwStopTime - m_dwStartTime) -
                                       m_dwCalibrationTime;
                 wsprintf (string, "NO MFC: Sent Msgs per second = %ld",
                          (LONG) (1000. * ((double)m_lMsgCount/dwElapsedTime)));
                 SetWindowText (hwnd, string);
                 }
               }
              return 0;

          }

         return DefWindowProc (hwnd, iMessage, wParam, lParam) ;
     }
