comment~
CR3.ASM -- Virtual CR3 Device
from Microsoft Systems Journal, October 1992
Copyright (c) 1992 Andrew Schulman.  All rights reserved.

Provides applications running under Windows Enhanced mode (Windows
apps, real-mode DOS apps, and protected-mode DOS apps) with access
to the CR3 register.  CR3 contains the _physical_ base address of
the page directory, which in turn contains physical addresses of
page tables.  A program calls CR3.386 using its V86 or PM API; the
API entry point is retrieved with INT 2Fh AX=1684h BX=28C2h (CR3.386's
device ID).  The entry point is called with AX=1 to get CR3 into DX:AX:
   unsigned long (far *cr3_vxd)(void);
   unsigned long cr3;
   cr3_vxd = GetDeviceAPI(0x28C2);    // call 2F/1684
   if (cr3_vxd) {
      _asm mov ax, 1
      cr3 = (*cr3_vxd)();
      }
   else fail("Requires device=cr3.386 in SYSTEM.INI [386Enh]");
The returned address is _physical_, not linear, and must be mapped in
using a service such as DPMI INT 31h AX=0800h.     

To build:
   set include=\ddk\include
   masm5 -p -w2 cr3;
   link386 cr3,cr3.386,,,cr3.def
   addhdr cr3.386

Add device=cr3.386 to SYSTEM.INI [386Enh]
~

.386p

INCLUDE VMM.INC

;*****************************************************************************
;                   E Q U A T E S
;*****************************************************************************

; The device ID -- get your own ID from vxdid@microsoft.com
RUNNING_DOG_OEM     EQU 326
CR3_DEVICE_ID       EQU 2
CR3_VxD_ID          EQU (RUNNING_DOG_OEM SHL 5) OR CR3_DEVICE_ID  ; 28C2h
VERS_MAJ            EQU 1
VERS_MIN            EQU 0
VERSION             EQU ((VERS_MAJ SHL 8) OR VERS_MIN)

CFlag               EQU 1

;*****************************************************************************
;        V I R T U A L   D E V I C E   D E C L A R A T I O N
;*****************************************************************************

; Together with an optional Service_Table (not used here), 
; this will become CR3_DDB in the .386 file
Declare_Virtual_Device CR3, VERS_MAJ, VERS_MIN, CR3_VxD_Control, \
    CR3_VxD_ID, Undefined_Init_Order, \
    CR3_API_Handler, CR3_API_Handler,

;*****************************************************************************
;           R E A L   M O D E   I N I T I A L I Z A T I O N
;*****************************************************************************

; This segment of 16-bit real mode code is optional.  Displaying a
; copyright message here is obnoxious, but it's a good example of how
; a VxD can contain 16-bit real mode code.  Unfortunately it's only
; available during Windows initialization.

VXD_REAL_INIT_SEG

real_init proc near
    mov ah, 9
    mov dx, offset copyright
    int 21h
    xor ax, ax          ; set up to tell Windows it's okay 
    xor bx, bx          ; to keep loading this VxD
    xor si, si
    xor edx, edx
    ret
real_init endp

copyright   db  'CR3.386 -- CR3 Access VxD v. 1.0',0dh,0ah
            db  'Copyright (c) 1992 Andrew Schulman. All Rights Reserved.'
            db  0dh,0ah,'$'

VXD_REAL_INIT_ENDS

;*****************************************************************************
;           L O C K E D   C O D E   S E G M E N T
;*****************************************************************************

VxD_LOCKED_CODE_SEG

; This VxD doesn't make any use of Control events.  VxDs 
; can handle events such as Create_VM, VM_Resume, Debug_Query,
; etc. in here
BeginProc CR3_VxD_Control
    clc
    ret
EndProc CR3_VxD_Control

VxD_LOCKED_CODE_ENDS

;*****************************************************************************
;               O N L Y   D A T A   S E G M E N T
;*****************************************************************************

VxD_DATA_SEG

; API jump table: this VxD API supports only two functions
CR3_API_Call    label dword
                dd  offset32 Get_Version        ; AX=0
                dd  offset32 Get_CR3            ; AX=1

CR3_API_MaxCall EQU ( $ - CR3_API_Call ) / 4

VxD_DATA_ENDS

;*****************************************************************************
;          M O V E A B L E   C O D E   S E G M E N T
;*****************************************************************************

VxD_CODE_SEG

; This is the handler for both V86 and PM API calls.  Its address
; is installed (for both modes) in the Declare_Virtal_Device statement.
BeginProc   CR3_API_Handler
    movzx   eax, [ebp.Client_AX]            ; get caller's AX register
    cmp     eax, CR3_API_MaxCall            ; valid function number?
    jae     short fail
    and     [ebp.Client_EFlags], NOT CFlag  ; clear carry for success
    call    CR3_API_Call[eax * 4]           ; call through table
    ret
fail:
    or      [ebp.Client_EFlags], CFlag
    ret
EndProc     CR3_API_Handler

; API function AX=0 (CR3_Get_Version).  Yawn!
BeginProc   Get_Version
    mov     [ebp.Client_AX], VERSION
    ret
EndProc     Get_Version

; API function AX=1 (CR3_Get_CR3).  Put the contents
; of CR3 into caller's DX:AX registers (figure that most
; clients will be 16-bit).
BeginProc   Get_CR3
    mov     eax, cr3    ; <--- the whole point of this VxD!!
    mov     edx, eax    ; get EAX into DX:AX
    shr     edx, 16
    mov     [ebp.Client_DX], dx     ; move into caller's registers
    mov     [ebp.Client_AX], ax
    ret
EndProc     Get_CR3

VxD_CODE_ENDS

    END

