/* 
FIND_API.C
from Microsoft Systems Journal, October 1992
Copyright (c) 1992 Andrew Schulman.  All rights reserved.

Locate V86 and PM VxD API entry points in Windows.
Built with DPMISHEL.C
Runs first in V86 mode, then in protected mode
Runs same code (find_api_loop) in each mode
*/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#define LOBYTE(w)           ((unsigned char)(w))
#define HIBYTE(w)           ((unsigned char)((unsigned short)(w) >> 8))

// database of VxD ID's and names we know about
typedef struct {
    unsigned short id;
    char *name;
    } VXDNAME;
VXDNAME vxdname[] = {
    0x0001, "VMM -- Virtual Machine Manager",
    0x0002, "Debug -- Win386 Debug Device",
    0x0003, "VPICD -- Virtual Programmable Interrupt Controller "
                "(PIC) Device",
    0x0004, "VDMAD -- Virtual Direct Memory Access (DMA) Device",
    0x0005, "VTD -- Virtual Timer Device",
    0x0006, "V86MMGR -- Virtual-8086 Mode Memory Manager Device",
    0x0007, "PageSwap -- Demand Paging Swap Device Services",
    0x0008, "Parity",
    0x0009, "Reboot",
    0x000A, "VDD -- Virtual Display Device",
    0x000B, "VSD -- Virtual Sound Device",
    0x000C, "VMD -- Virtual Mouse Device",
    0x000D, "VKD -- Virtual Keyboard Device",
    0x000E, "VCD -- Virtual COMM Device",
    0x000F, "VPD -- Virtual Printer Device",
    0x0010, "BlockDev -- formerly Virtual Hard Disk Device (VHD)",
    0x0011, "VMCPD -- Virtual Math Coprocessor (MCP) Device",
    0x0012, "EBIOS",
    0x0013, "BIOSXlat -- BIOS Protected-Mode Translation",
    0x0014, "VNETBIOS -- Virtual NetBIOS Device",
    0x0015, "DOSMGR -- Virtual MS-DOS Manager",
    0x0016, "WINLOAD",
    0x0017, "SHELL",
    0x0018, "VMPoll",
    0x0019, "VPROD",
    0x001A, "DOSNET",
    0x001B, "VFD -- Virtual Floppy Device",
    0x001C, "LoadHi -- Global EMM Import",
    0x001D, "WINDEBUG",
    0x001E, "TSRLoad -- TSR instance utility",
    0x001F, "BIOSHook -- BIOS Interrupt Hooker VxD",
    0x0020, "INT13 -- Virtual INT 13h (BIOS Disk) Device",
    0x0021, "PageFile -- Demand Paging Swap Device Services",
    0x0022, "SCSI",
    0x0023, "MCA_POS -- Microchannel Architecture Programmable "
                "Option Select",
    0x0024, "SCSIFD -- SCSI FastDisk",
    0x0025, "VPEND -- Virtual Pen Device",
    0x0026, "APM -- Advanced Power Management",
    0x0200, "Novell IPX",
    0x0202, "Win386 Soft-ICE/W Debugger",
    0x0442, "VTDAPI",
    0x0445, "VSBD -- Virtual SoundBlaster Device",
    0x1020, "VCV -- Microsoft C/C++ 7.0 CodeView",
    0x28C0, "VXD.386 -- Generic Virtual Device Driver",
    0x28C1, "PUSHKEYS -- VKD_Force_Keys Device",
    0x28C2, "VCR3D -- Virtual CR3 Device",
    0,      "",
    } ;

typedef void (far *FUNCPTR)(void);

// call the Windows "Get Device Entry Point Address" function
// Interrupt 2Fh Function 1684h
FUNCPTR GetDeviceAPI(unsigned short vxd_id)
{
    _asm    push    di
    _asm    push    es
    _asm    mov     ax, 0x1684
    _asm    mov     bx, vxd_id
    _asm    xor     di, di
    _asm    mov     es, di
    _asm    int     0x2f
    _asm    mov     ax, di
    _asm    mov     dx, es
    _asm    pop     es
    _asm    pop     di
    // return value in DX:AX
}

find_api_loop()
{
    unsigned i;
    FUNCPTR fp;
    VXDNAME *pname;
    char *name;
    
    // for each possible device id, see if there's an API
    for (i=0; i<0xffff; i++)
        if (fp = GetDeviceAPI(i))
        {
            // see if we know this device's name
            for (name="??", pname=vxdname; pname->id != 0; pname++)
                if (i == pname->id)
                {
                    name = pname->name;
                    break;
                }
                
            // print the device number, name, and entry point
            printf("Device %04Xh (%s) @ %Fp\n", 
                i, name, fp);
        }
}

v86_main()
{
    fputs("Find Windows VxD APIs version 1.00\n", stderr);
    fputs("Copyright (c) 1992 Andrew Schulman.  All rights reserved.\n\n",
        stderr);
    
    puts("Virtual-8086 (V86) VxD APIs:");
    find_api_loop();
    return 0;
}

pmode_main()
{
    puts("\nProtected-mode VxD APIs:");
    find_api_loop();
    
    return 0;
}

