1             
                                                                                                       /* 
PAGEDIR.C -- Display page directory in Windows Enhanced mode
Microsoft Systems Journal, December 1992
Andrew Schulman
*/

#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "windows.h"
#include "protmode.h"

void fail(char *s)
{
    MessageBox(NULL, s, "PAGEDIR", MB_OK);
    exit(1);
}

static char buf[1024] = {0};
static char title[128] = {0};

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
    LPSTR lpCmdLine, int nCmdShow)
{
    const DWORD far *pagedir;
    int i;
    
    /* map page directory into program's address space */
    pagedir = get_pagedir();
    
    wsprintf(title, "PAGEDIR - Physical %08lX - Linear %08lX", 
        pagedir_phys, pagedir_lin);
    
    strcpy(buf, "PgTab\tPhysical\t\tLinear Address Range\n");
    
    /* for each possible page directory... */
    for (i=0; i<1024; i++)
        if (pagedir[i] & 1)     // present bit
        {
            char tmp[64];
            wsprintf(tmp, "%u\t%08lX\t%08lX-%08lX\n", 
                i,
                pagedir[i] & ~4095,
                0x400000L * i, (0x400000L * (i+1))-1);
            strcat(buf, tmp);
        }
        
    MessageBox(NULL, buf, title, MB_OK);
    free_mapped_linear(pagedir);
    return 0;
}
      
        wsprintf(tmp_buf, "%04X (%s)\t%08lX\t%04lX\n", 
            h, flagname,
            GetSelectorBase(h),      w [d[Me   D [   40gtpgG[ h4
  h  NhnhG\	  H   G+\  ,                        .  @  V  m  o                       A  e  h              9  ^  d          $  /  J   J              '  Q  s        d          $  /  J      Arial    Q  S  q  s              *  :  F  L           