/* 
PROTMODE.H
from December 1992 Microsoft Systems Journal
Andrew Schulman
*/

#ifndef DPMI_APP
// the following are missing from some versions of WINDOWS.H
#ifdef __cplusplus
extern "C" {
#endif  
    extern WORD FAR PASCAL AllocSelector(WORD sel);
    extern WORD FAR PASCAL FreeSelector(WORD sel);
    extern WORD FAR PASCAL SetSelectorBase(WORD sel, DWORD base);
    extern WORD FAR PASCAL SetSelectorLimit(WORD sel, DWORD limit);
    extern DWORD FAR PASCAL GetSelectorBase(WORD sel);
    extern DWORD FAR PASCAL GetSelectorLimit(WORD sel);
#ifdef __cplusplus  
    } 
#endif  
#endif

extern void fail(char *s);  // app has to define a fail() function

#define VCR3D       0x28c2

#ifndef MK_FP
#define MK_FP(s, o) \
    ((void far *)(((DWORD)(s)) << 16) + (o))
#endif

#pragma pack(1)

typedef struct {
    unsigned rpl : 2;
    unsigned ti : 1;
    unsigned index : 13;
    } SELECTOR; 

typedef struct {
    unsigned short limit_lo;
    unsigned short base_lo;
    unsigned char base_hi;
    unsigned char rts_lo;
    unsigned char limitrts_hi;
    unsigned char base_xhi;
    } DESCRIPTOR;

typedef struct {
    unsigned dir : 10;
    unsigned page : 10;
    unsigned offset : 12;
    } LINADDR;

typedef void (far *api_entry)(void);
typedef struct { WORD limit; DWORD base; } GDTR;

/* a few global variables */
extern DESCRIPTOR far *gdt;
extern DWORD pagedir_phys;
extern DWORD pagedir_lin;

api_entry get_vxd_api(WORD vxd_id);
DWORD get_cr3(void);
DWORD dpmi_phys_to_lin(DWORD phys_addr, DWORD num_bytes);
void far *map_linear(DWORD lin_addr, DWORD num_bytes);
void free_mapped_linear(void far *fp);
DWORD far *get_pagedir(void);
DWORD far *get_pagetab(DWORD far *pagedir, int pagetab_num);
void sgdt(GDTR far *pgdtr);
DESCRIPTOR far *get_gdt(void);
BOOL is_system_seg(DESCRIPTOR far *desc);
DWORD get_base(DESCRIPTOR far *desc);
DWORD get_limit(DESCRIPTOR far *desc);
WORD sldt(void);
DESCRIPTOR far *get_ldt(void);
