;; LOADHI demonstrates how a memory-resident program run under
;; MS-DOS version 5 may load itself high if upper memory blocks
;; are available.  The commands
;;      MASM LOADHI /ML;
;;      LINK LOADHI;
;;      EXE2BIN LOADHI.EXE LOADHI.COM
;; generate a COM-formatted executable from the source file.
 
SET_LINK        equ     1                       ;Set upper memory link
FF_HIGH_ONLY    equ     40h                     ;First-fit/high-only code
UMB_REQUIRED    equ     400h                    ;Paragraphs needed to load
 
LOADEXEC        struct
Env             dw      0                       ;Environment block segment
Tail            dd      ?                       ;Command tail address
FCB_1           dd      ?                       ;First FCB address
FCB_2           dd      ?                       ;Second FCB address
LOADEXEC        ends
 
code            segment
                assume  cs:code
                org     100h
Begin:          jmp     Init
 
; *** Code that will remain in memory after the program has terminated goes here ;; If the program is loaded high, Init calls MS-DOS Function 31h to
;; become resident in memory.  If the program is loaded low and it is
;; the first instance of the program in memory, Init attempts to load
;; and execute a second instance of the program in upper memory.  If
;; the program is loaded low and it is the second instance, Init
;; terminates the program.
                assume  cs:code,ds:code
 
Init            proc    near
                mov     ax,cs                   ;Branch if the program
                cmp     ax,0A000h               ;was not loaded high
                jb      LoadedLow
 
                ; *** Perform initializations here ***
                ; *** (revector interrupts, etc.)  ***
 
                mov     dx,offset Init + 15     ;Compute number of
                mov     cl,4                    ;paragraphs of memory
                shr     dx,cl                   ;needed after termination
                mov     ax,3100h                ;Terminate and stay
                int     21h                     ;resident
;
; If this is the second instance of this program in memory, terminate now.
LoadedLow:      mov     es,ds:[16h]             ;Load parents PSP address
                mov     di,100h                 ;Set DI equal to 100h
                mov     si,di                   ;Set SI equal to DI
                mov     cx,100h                 ;Set counter for 256 bytes
                cld                             ;Clear direction flag
                repe    cmpsb                   ;Compare 256 bytes
                jne     SetLink                 ;Branch iftheyre not equal
                jmp     ErrorExit3              ;Exit if they are
;
; Set the upper memory link and change the allocation strategy to high-only.
SetLink:        call    SaveMemState            ;Save the memory state
                mov     ax,5803h                ;Link upper and
                mov     bx,SET_LINK             ;conventional memory
                int     21h
                mov     dx,offset Message2      ;Branch if call failed
                jc      ErrorExit2
 
                mov     ax,5801h                ;Set allocation strategy
                mov     bx,FF_HIGH_ONLY         ;to first-fit/high-only
                int     21h
 
                mov     ah,48h                  ;Find the size of the
                mov     bx,0FFFFh               ;largest free UMB
                int     21h
 
                mov     dx,offset Message3      ;Branch if the largest free
                cmp     bx,UMB_REQUIRED         ;UMB is not large enough to
                jb      ErrorExit1              ;hold the program
;
; EXEC another instance of the program.
                mov     es,ds:[2Ch]             ;Get env segment in ES
                xor     di,di                   ;Point DI to segment base
                xor     ax,ax                   ;Zero AX
 
TryAgain:       scasw                           ;Scan for two zero bytes
                jz      ZeroesFound             ;Branch if they were found
                dec     di                      ;Otherwise decrement DI and
                jmp     TryAgain                ;try again
 
ZeroesFound:    add     di,2                    ;Point DI to program name
                mov     dx,di                   ;Transfer the address to DX
                mov     ax,cs                   ;Get PSP address in AX
                mov     es,ax                   ;Transfer address to ES
 
                mov     word ptr pb.Tail,80h    ;Load parameters block
                mov     word ptr pb.Tail[2],ax  ;with pointers to data
                mov     word ptr pb.FCB_1,5Ch   ;objects
                mov     word ptr pb.FCB_1[2],ax
                mov     word ptr pb.FCB_2,6Ch
                mov     word ptr pb.FCB_2[2],ax
                mov     bx,offset pb            ;ES:BX -> Parameter block
 
                push    ds                      ;Save DS
                mov     ds,ds:[2Ch]             ;Point DS to env segment
                assume  ds:nothing              ;DS:DX -> Program name
 
                mov     ax,4B00h                ;Load and execute the program
                int     21h
 
                pop     ds                      ;Restore DS
                assume  ds:code
                jc      LoadFailed              ;Branch if EXEC failed
 
                mov     ah,4Dh                  ;Get the return code
                int     21h
                or      al,al                   ;Branch if the return
                jnz     LoadFailed              ;code is not zero
 
                mov     ah,09h                  ;Display message saying
                mov     dx,offset Message1      ;the program was loaded
                int     21h                     ;high
                call    RestoreMemState         ;Restore the memory state
                mov     ax,4C00h                ;Terminate this instance
                int     21h                     ;of the program
 
LoadFailed:     mov     dx,offset Message4      ;Point DX to error message
ErrorExit1:     call    RestoreMemState         ;Restore the memory state
ErrorExit2:     mov     ah,09h                  ;Display the error message
                int     21h
ErrorExit3:     mov     ax,4C01h                ;Terminate with a return
                int     21h                     ;code of 1
Init            endp
 
;; SaveMemState saves the current memory allocation strategy and
;; upper memory link flag.
 
SaveMemState    proc    near
                mov     ax,5800h                ;Save the current memory
                int     21h                     ;allocation strategy
                mov     Strategy,ax
                mov     ax,5802h                ;Save the current upper
                int     21h                     ;memory link flag
                mov     byte ptr LinkFlag,al
                ret                             ;Return to caller
SaveMemState    endp
;; RestoreMemState restores the memory allocation strategy and
;; upper memory link flag saved earlier.
RestoreMemState proc    near
                mov     ax,5801h                ;Restore the memory
                mov     bx,Strategy             ;allocation strategy
                int     21h
                mov     ax,5803h                ;Restore the upper
                mov     bx,LinkFlag             ;memory link flag
                int     21h
                ret                             ;Return to caller

RestoreMemState endp
 
Message1        db      The program was successfully loaded high,13,10,$
Message2        db      There are no UMBs to load the program into,13,10,$
Message3        db      Insufficient upper memory,13,10,$
Message4        db      Attempt to load the program high failed,13,10,$
 
Strategy        dw      ?                       ;Memory allocation strategy
LinkFlag        dw      0                       ;Upper memory link flag
pb              LOADEXEC <>                     ;EXEC parameter block
 
code            ends
                end     Begin
