{
  PLARRAY.PAS unit, Copyright 1990,91 by A.A.Efros.
  This unit is a part of MELODY MASTER v2.1 Programmer Support Files.
  It is used to play music in Turbo Pascal 4.0 and up. The music is
  generated using MELODY MASTER's output to "TP array".

  INSTRUCTIONS:
    1. Run MELODY MASTER main program (MM.EXE or MMCGA.EXE).
    2. Load (F3) the melody you want.
    3. Output (F7) the melody choosing "TP array" option.
    4. Exit MELODY MASTER (Alt-X).
    5. Edit this file so the include statement {$I ...} will have
       the name of your music file.
    6. Include PLARRAY unit in the "uses" section of YOUR program.
    7. When you want the music to be played, call PlayArray procedure
       with one of parameters: Legato1, Legato2, Normal, or Staccato.
       This would determine the style the music will be played in.

  SAMPLE PROGRAM:

    program Sample;
    uses
       Your_units, PlArray;
    . . .
    begin
      . . .
      PlayArray(Staccato);
      . . .
    end.
}

unit PlArray;

INTERFACE

uses crt;
type
  StyleType = (Legato1, Legato2, Normal, Staccato);

procedure PlayArray(Style : StyleType);

IMPLEMENTATION

{$I FILENAME.PAS} { <--- Put the file name of your music here! }

procedure PlayArray(Style : StyleType);
var
  i : integer;
begin
  for i := 1 to MAX do
  begin
    if (Melody[i,1] = 0)
    then
      begin
        NoSound;
        Delay(Melody[i,2]);
      end
    else
      begin
        sound(Melody[i,1]);
        case Style of
          Legato1 : delay(Melody[i,2]);
          Legato2 : begin
                      delay(Melody[i,2]);
                      NoSound;
                    end;
           Normal : begin
                      delay(Round(Melody[i,2] * 0.875));
                      NoSound;
                      delay(Round(Melody[i,2] * 0.125));
                    end;
         Staccato : begin
                      delay(Round(Melody[i,2] * 0.75));
                      NoSound;
                      delay(Round(Melody[i,2] * 0.25));
                    end;
        end;
      end;
  end;
  NoSound;
end;

end.
