/*
                         Function Tone for C. 
     For C compilers without Sound, Delay and Nosound funcions.
      From "C primer plus"  by  M.Waite, S.Prata and D.Martin. 
*/

#include <dos.h>
#define TIMERMODE 182
#define FREQSCALE 1190000L
#define TIMESCALE 150L	/* You can change it for your computer */
#define T_MODEPORT 67
#define FREQPORT 66
#define BEEPPORT 97
#define ON 79

void tone(freq, time)
int freq, time;
{
   int hibyt, lobyt, port;
   long i, count, divisor;


   count = TIMESCALE * time;
   port = inp(BEEPPORT);
   if (freq > 0)
   {
      divisor = FREQSCALE / freq;
      lobyt = divisor % 256;
      hibyt = divisor / 256;
      outp(T_MODEPORT, TIMERMODE);
      outp(FREQPORT, lobyt);
      outp(FREQPORT, hibyt);
      outp(BEEPPORT, ON);
   }
   for (i = 0;i < count;i++)
   ;
   outp(BEEPPORT, port);
}


