#include <stdio.h>
#include <memory.h>
#include <malloc.h>
#include <graph.h>

#include "externs.h"

#define VDD_SEG 0x40
#define VDD_ROWS_OFF 0x84	/* This points to a BYTE	*/
#define VDD_COLS_OFF 0x4a	/* This points to a WORD (int) */

#define MK_FP(__o,__s) (void far *)(((unsigned long)(__s)<<16)|(unsigned)(__o))

#ifdef DEBUG
# define BUG(__s) fprintf(stderr,__s); getch()
#else
# define BUG(__s) ;
#endif

static void restore_screen(void);
static void saveScreen(void);
static void find_screen(void);

extern void exit(int);
extern int getch(void);
extern int save_screen;

static int rows, cols;
static char far *vid_buffer=NULL;
static char far *vidstatebuffer=NULL;
static char *old_vid;
static int old_page;
static short old_color;
static struct rccoord old_pos;
	
void init_text(void)
{
    setvbuf(stdout,NULL,_IONBF,1);
    if ((old_page = _getactivepage()) != 0)
        _setactivepage(0);
    old_pos = _gettextposition();
    old_color = _gettextcolor();
	find_screen();
    if (save_screen)
        saveScreen();
}


void end_text(void)
{
	BUG("We are in end_text - Press a Key");
    if (old_page)
        _setactivepage(old_page);

    set_mode();
    fix_vid();
    restore_screen();
    _settextposition(old_pos.row,old_pos.col);
    _settextcolor(old_color);

}

static void find_screen(void)
{
	struct rccoord pos;
	unsigned char far *mono, far *color;
	unsigned char old_mono, old_color, test_char;

	mono = (char far *)MK_FP(0,0xb000);
	color = (char far *)MK_FP(0,0xb800);

	pos = _settextposition(0,0);

	old_mono = *mono;
	old_color = *color;

	test_char = 0x88;
	for(test_char=0x88;(test_char==old_mono)||(test_char==old_color);
	  test_char--);

	putchar(test_char);

	_settextposition(pos.row, pos.col);
	if (*mono == test_char) {
		vid_buffer = mono;
		_settextposition(0,0);
		putchar(old_mono);
		BUG("We are mono - Press a Key\n");
	} else if (*color == test_char) {
		vid_buffer = color;
		_settextposition(0,0);
		putchar(old_color);
		BUG("We are color - Press a Key\n");
	} else {
		int result;

		fprintf(stderr, "Cannot Recognize video type - cannot save screen\n");
		fprintf(stderr, "Press ESC to exit, any other key to continue\n");
		result = getch();
		if (result == 0x1b)
			exit(-1);
        save_screen = FALSE;
	}

	_settextposition(pos.row, pos.col);
}

static void saveScreen(void)
{
    int size;

    rows = *(char far *)MK_FP(VDD_ROWS_OFF,VDD_SEG) + 1;
	cols = *(int far *)MK_FP(VDD_COLS_OFF,VDD_SEG);

	if ((old_vid = (char *) malloc((rows*cols)<<1)) == NULL) {
		printf("Couldn't get enough memory - exiting\n");
		exit(-1);
	}
	_fmemcpy(old_vid,vid_buffer,(rows*cols)<<1);

    size = get_size();
    size *=64;
    vidstatebuffer=malloc(size);
    get_mode(vidstatebuffer);
}

static void restore_screen(void)
{	
	_fmemcpy(vid_buffer, old_vid, (rows*cols)<<1);
    free(old_vid);
    free(vidstatebuffer);
}

