/**************************************************************************/
/*
*  Host and local machine configuration information.
*
****************************************************************************
*                                                                          *
*      NCSA Telnet for the PC                                              *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*      This program is in the public domain.                               *
*                                                                          *
****************************************************************************
*																		   *
*    Copyright (c) 1987, Board of Trustees of the University of Illinois   *
*                                                                          *
****************************************************************************
*	5/88	clean up for 2.3 release, JKM	
*/

#ifndef HOSTFORM_H

/*
*  Linked list of structures which describe other machines.
*  Arranged one per session with unique session names.
*/
struct machinfo {
	unsigned char *sname,		/* pointer to name of session */
		*hname,                 /* pointer to name of that machine */
		*font,					/* font name, if we can do it */
		*ftpoptions,			/* options for FTP command line (ALT-F) */
		hostip[4],				/* IP number of this machine */
		gateway,				/* gateway preference, start with 1 */
		nameserv,				/* nameserver preference, start with 1 */
		bksp,					/* backspace value */
		halfdup,				/* half duplex required */
		crmap,					/* Strange Berkeley 4.3 CR mode needed */
		vtwrap,					/* flag on when need wrap mode */
		vtwidth;				/* how wide screen should be for this session */
	int clearsave,				/* whether to save cleared lines */
		fsize,					/* font size in points */
		nfcolor,				/* normal foreground */
		nbcolor,				/* normal background */
		bfcolor,				/* blink             */
		bbcolor,
		ufcolor,				/* underline */
		ubcolor,
		port,					/* TCP port number to access, default = 23 (telnet) */
		mno,					/* machine number for reference */
		mstat,					/* status of this machine entry */
		bkscroll,				/* how many lines to save */
		retrans,				/* initial retrans timeout */
		conto,					/* time out in seconds to wait for connect */
		window,					/* window, will be checked against buffers */
		maxseg,					/* maximum receivable segment size */
		mtu;					/* maximum transfer unit MTU (out) */
	struct machinfo *next;		/* surprise, its a linked list! */
};

struct machinfo *Sgethost(),
				*Shostlook(),
				*Slooknum(),
				*Slookip(),
				*Smadd();
/*
*  status fields for mstat, what do we know about that machine?
*/
#define NOIP 1					/* we don't have IP number */
#define UDPDOM 3				/* there is a UDP request pending on it */
/*  The next 20 numbers are reserved for UDPDOM */
#define HAVEIP 50				/* at least we have the # */
#define HFILE 70				/* we have IP number from host file */
#define DOM 71					/* we have an IP number from DOMAIN */
#define FROMKIP 72				/* have IP# from KIP server */
/*
*   Configuration information which 
*   the calling program may want to obtain from the hosts file.
*   The calling program should include hostform.h and call
*   Sgetconfig(cp)
*     struct config *cp;
*   which will copy the information to the user's data structure.
*/
struct config {
unsigned char netmask[4],		/* subnetting mask being used */
		irqnum,					/* which hardware interrupt */
		myipnum[4],				/* what is my IP #? */
		broadip[4],				/* IP broadcast address */
		me[32],					/* my name description (first 30 chars) */
		color[3],				/* default colors to use */
		hw[10],					/* hardware type for network */
		video[10],				/* video graphics hardware available */
		ega43,					/* 43 line ega mode */
		*termtype,				/* terminal type specification */
		*zone,					/* AppleTalk zone for KIP NBP */
		*defdom,				/* default domain */
		*capture,				/* pointer to where the capture file name is */
		*pass,					/* pointer to where the password file name is */
		*hpfile,				/* HP file name */
		*psfile,				/* PS file name */
		*tekfile;				/* tek file name */
int 	cursortop,				/* top line of cursor */
		cursorbottom,			/* bottom line of cursor */
		nstype,					/* nameserver = 1-domain 2-IEN116  */
		domto,					/* time out for UDP domain request */
		ndom,					/* number of retries for domain requests */
		timesl;					/* time slice */
unsigned int address,			/* segment address */
		ioaddr;					/* I/O address */
unsigned int havemask:1,		/* do we have a netmask? */
		bios:1,					/* flag, do we want to use BIOS for screen access */
		tek:1,					/* flag, enable tektronix graphics */
		ftp:1,					/* flag, enable ftp server */
		rcp:1,					/* flag, enable rcp server */
		wire:1,					/* what type of connector? (thin or thick)*/
		comkeys:1,				/* flag, commandkeys=yes */
		wingoaway:1,			/* flag, whether a window goes away when session ends or waits for a keypress */
		clock:1,				/* flag, whether to display the clock or not */
		autoscroll:1;			/* flag, do we perform a fast scroll in scrollback */
};

#define HOSTFORM_H
#endif
