/* cu-notic.txt		 NCSA Telnet version 2.2C	 2/3/89
   Notice:
		Portions of this file have been modified by
		The Educational Resources Center of Clarkson University.

		All modifications made by Clarkson University are hereby placed
		in the public domain, provided the following statement remain in
		all source files.

		"Portions Developed by the Educational Resources Center, 
				Clarkson University"

		Bugs and comments to bkc@omnigate.clarkson.edu
								bkc@clgw.bitnet

		Brad Clements
		Educational Resources Center
		Clarkson University
*/

/* packet.c - FTP Software Packet Interface for NCSA TELNET
   Author: Brad Clements  bkc@omnigate.clarkson.edu
		   Clarskon University
		   10/24/88

   Assumes Microsoft C large model
*/
/*
*  packet.c
*****************************************************************************
*																		  	*
*	  part of:																*
*	  TCP/UDP/ICMP/IP Network kernel for NCSA Telnet						*
*	  by Tim Krauskopf														*
*																		  	*
*	  National Center for Supercomputing Applications					 	*
*	  152 Computing Applications Building								 	*
*	  605 E. Springfield Ave.											 	*
*	  Champaign, IL  61820													*
*																		  	*
*****************************************************************************
*
*	Packet driver code modifed for Microsoft and Lattice C by
*		Quincey Koziol 8/18/89
*/
/* #define XDEBUG  1 */

/*#define DEBUG*/

#ifdef DEBUG	
#include <conio.h>
#endif

#include "debug.h"

#ifdef	__TURBO__
#pragma inline
#endif
#include <stdio.h>
#include <string.h>
#include <dos.h>
#ifdef MEMORY_DEBUG
#include "memdebug.h"
#endif
#include "whatami.h"
#include "windat.h"
#include "externs.h"
#define MK_FP(seg,ofs)	((void far *) (((unsigned long)(seg) << 16) | (unsigned)(ofs)))

int	 ip_handle=(-1),arp_handle=(-1),rarp_handle=(-1);

extern unsigned char rstat;					/* status from last read */
extern char *bufpt,*bufend,*bufread,*buforg;
extern int bufbig,buflim;
static int packet_vector;					   /* non-zero if we found it */

#define	IC_ANY  	0
#define IC_ETHERNET	 1
#define IC_SLIP		 6
#define	IT_ANY		0xFFFF

extern	void pkt_receiver();
static int locate_pkt_vector(int vec);
static  int	 oldvec;

static int locate_pkt_vector(vec)			 /* search for the packet driver */
int vec;
{
		struct vector_ptr{
				char far *real_vector;
		} *vptr;
		char	far	 *xvptr;
		int	 vector,vmax;

		if(packet_vector)
				return(0);		 /* already found!	   */
		vector = 0x60;
		vmax = 0x7f;

#ifdef DEBUG
		printf("%s[%d],vec = %d\n",__FILE__,__LINE__,vec);
		printf("setting vec to 0x60\n");
		printf("%s[%d],vec = %d\n",__FILE__,__LINE__,vec);
#endif
		if((vec >= 0x60) && (vec <= 0x7f))
			vmax = vector = vec;
		else if (vec != 0) /* zero specifies use search */
			n_puts("Warning, packet driver vector incorrect, using default search\n\r");

		for(; vector <= vmax; vector++) {
			vptr = (struct vector_ptr *)MK_FP(0,vector * 4);
			xvptr = vptr->real_vector;
#ifdef DEBUG
			printf("Checking vector %X\n", vector);
			printf("vptr = %p\n",vptr);
			printf("real vec = %p\n",xvptr);
			printf("string = %s\n",xvptr+3);
#endif
			if(!strncmp(xvptr+3,"PKT DRVR",8)) {
				packet_vector = vector;
				BUG("found vector");
				return(0);
			}
		}

		BUG("didn't find vector");
		return(-1);
}

int pkt_access_type(if_class,if_type,if_number,type,typelen,receiver)
int if_class,
	if_type,
	if_number;
char *type;
int typelen;
void  (*receiver)();
{
   union REGS regs;
   struct SREGS segregs;

   if(!packet_vector)
		return(-1);
	regs.h.ah = 2;
	regs.h.al= (char)if_class;
	regs.x.bx = if_type;
	regs.x.dx = if_number;
	segregs.ds = FP_SEG(type);
	regs.x.si = FP_OFF(type);
	regs.x.cx = typelen;
	segregs.es = FP_SEG(receiver);
	regs.x.di = FP_OFF(receiver);
	int86x(packet_vector,&regs,&regs,&segregs);
	if(regs.x.cflag) {
		char	buff[512];

		sprintf(buff,"Packet Access Type Error %d\n\r",regs.h.dh);
		n_puts(buff);
		return(-1);
	  }	/* end if */
   return(regs.x.ax);
}

int pkt_set_rcv_mode(handle,mode)
int handle,
	mode;
{
   union REGS regs;

   if(!packet_vector)
	  return(-1);
   regs.x.ax = 0x2000;
   regs.x.bx = handle;
   regs.x.cx = mode;
   int86(packet_vector,&regs,&regs);
   if(regs.x.cflag) 
	  return(regs.h.dh);
   return(0);
}

void pkt_release_type(handle)
int	handle;
{
   union REGS regs;
   
   if(!packet_vector)
	  return;

   regs.x.ax = 0x0300;
   regs.x.bx = handle;
   int86(packet_vector,&regs,&regs);
   return;
}

void pkt_get_address(handle,storage,len)
int handle;
char *storage;
int len;

{
   union REGS regs;
   struct SREGS segregs;

   if(!packet_vector)
		return;

   regs.x.ax = 0x0600;
   regs.x.bx = handle;
   regs.x.di = FP_OFF(storage);
   segregs.es = FP_SEG(storage);
   regs.x.cx = len;
   int86x(packet_vector,&regs,&regs,&segregs);
   if(regs.x.cflag) {
		char	buff[128];
		sprintf(buff,"Error retrieving address %d\n\r",regs.h.dh);
		n_puts(buff);
   }
}

int pkt_send(packet,len)
char *packet;
int len;

{
   union REGS regs;
   struct SREGS segregs;

   if(!packet_vector)
	  return(-1);
	regs.h.ah=4;
	regs.h.al=0;
	regs.x.si = FP_OFF(packet);
	regs.x.cx = len;
	segregs.ds = FP_SEG(packet);
	int86x(packet_vector,&regs,&regs,&segregs);
#ifdef  XDEBUG
		{ char xx[80]; 
		   sprintf(xx,"pkt_send %d bytes rc is %d (%d)\n",len, regs.h.dh, regs.x.cflag);
		   n_puts(xx);
		}
#endif

	if(regs.x.cflag)
		return(regs.h.dh);
	return(0);
}

/* we try and locate the packet driver and open ARP and IP handles. */
/* also open RARP handle */
int pketopen(s,irq,address,ioaddr)
unsigned char *s;			/* ethernet address */
unsigned int	irq;			/* don't need this	  */
unsigned int	address;		/* address is packet class */
unsigned int	ioaddr;			/* packet int, or 0 */
{
	static char iptype[]={8,0};
	static char arptype[]={8,6};
	static char rarptype[]={0x80,0x35};
	char buff[256];

	irq=irq;		/* get rid of compiler warning */
	if(!locate_pkt_vector(ioaddr))
		oldvec = ioaddr;
	else {
		n_puts("No Packet Driver found at specified location. Change ioaddr in config.tel\n\r");
		return(-1);
	  }	/* end else */
	if(ip_handle!=(-1))
		return(0);
	if(address<1 || address>11)		/* 11 is the highest number for if_class at the present time */
		address = IC_ETHERNET;

	if((ip_handle = pkt_access_type(address,IT_ANY,0,iptype,sizeof(iptype),pkt_receiver)) == -1) {
		sprintf(buff,"Can't Access IP handle interface type %d\n\rPacket Driver probably not loaded\n\r",address);
		n_puts(buff);
		return(-2);
	  }	/* end if */

	if((arp_handle = pkt_access_type(address,IT_ANY,0,arptype,sizeof(arptype),pkt_receiver)) == -1) {
		sprintf(buff,"Can't Access ARP handle\n\r");
		n_puts(buff);
		pkt_release_type(ip_handle);
		return(-3);
	  }	/* end if */

/* Grab the RARP handle also */
	if((rarp_handle = pkt_access_type(address,IT_ANY,0,rarptype,sizeof(rarptype),pkt_receiver)) == -1) {
		sprintf(buff,"Can't Access RARP handle\n\r");
		n_puts(buff);
		pkt_release_type(ip_handle);
		pkt_release_type(arp_handle);	/* let go of the arp handle also */
		return(-4);
	  }	/* end if */

	pkt_get_address(ip_handle,s,6);
	pkt_set_rcv_mode(ip_handle,3);	   /* receive broadcasts also */
	return(0);
}

int pkgetaddr(s,address,ioaddr)	   /* get the ethernet address */
unsigned char	*s;			/* ethernet address */
unsigned int	 address;		/* address is packet class */
unsigned int	 ioaddr;		/* packet int, or 0 */
{
   BUG("pkgetaddr");
   if(ip_handle==(-1))
	  return(pketopen(s,0,address,ioaddr));
   BUG("about to pkt_get_address");
   pkt_get_address(ip_handle,s,6);
   return(0);
}

void pkrecv()						/* no op for this interface	 */
{
}

int pketclose()					 /* throw away our handles */
{
   pkt_release_type(ip_handle);
   pkt_release_type(arp_handle);
   pkt_release_type(rarp_handle);
   return(0);
}

int pkxmit(packet,length)		   /* transmit a packet	*/
DLAYER *packet;
int	length;
{
   if(length < 60)
		length=60;			/* what a terrible hack! */
   if(pkt_send((char *)packet,length))
		return(-1);
   return(0);
}

unsigned pkt_es,pkt_di;

#ifdef _TURBOC_
void interrupt pkt_receiver2(bp,di,si,ds,es,dx,cx,bx,ax)
unsigned int bp,di,si,ds,es,dx,cx,bx,ax;
#else
void interrupt pkt_receiver2(es,ds,di,si,bp,sp,bx,dx,cx,ax)
unsigned int bp,sp,
	di,si,
	ds,es,
	dx,cx,bx,ax;
#endif
{
   char  *where_to_write;
   int   *save_packet_size;

   /* this receiver function assumes that between the first and second call
	  from the packet driver, the underlying telnet code will not access
	  the buffer.
   */

   /* here's an incoming packet from the packet driver, first see if we
	  have enough space for it */

	ds=ds;		/* get rid of compiler warnings */
	si=si;
	bp=bp;
	sp=sp;
	bx=bx;
	dx=dx;
	if(!ax) {
		if(bufbig <= buflim) {  /* if there is space remaining */
			if(bufpt > bufend)   /* if at end of wrap area then wrap it */
				bufpt = buforg;
			save_packet_size = (int *) bufpt;
			bufpt += sizeof(int);		/* we're so clean here! */
			where_to_write = bufpt;
			*save_packet_size = cx;
			bufpt += cx;
			bufbig += cx + sizeof(int);
			es = FP_SEG(where_to_write);
			di = FP_OFF(where_to_write);
			return;
		  }
		else {
			es = di = 0;				/* no room */
		}
	}
	return;					  /* we do nothing if its the second call */
}

void pketupdate()					/* update the pointers */
{
   int packet_size;
   int *size_ptr;


   size_ptr = (int *) bufread;
   packet_size = *size_ptr;
   bufread += packet_size + sizeof(int);
   if(bufread > bufend)
	  bufread = buforg;

	clear_int();
#ifdef __TURBO__
	asm cli					  /* inline assembly  no ints during this operation	 */
#endif
	bufbig -= packet_size + sizeof(int);
	set_int();
#ifdef __TURBO__
	asm sti					  /* inline assembly	  */
#endif
}

