/* txt2ps translator for use with Charon
	Copyright (C) 1990 Brad K. Clements, Clarkson University
	       All Rights Reserved.

	Portions based on Textps.c by Eric Gisin, egisin@waterloo.csnet		     
	


*/

#include <ctype.h> 
#include <time.h>
#include <string.h>
#define	STANDALONE	0
#include "callback.h"
#include "tagvalue.h"

char	*stackinfo="$STACKSIZE:4096";
#define	BUFFSIZE	1024
#define	OBUFFSIZE	1024
#define	FONTSIZE	12
#define	MAX_LINE_LENGTH	256
char *Head1[] = {
    "%!PS-Adobe-1.0\n",
    "%%Creator: text_ps.c\n",
    "%%DocumentFonts: Courier, Helvetica, Times-Roman\n",
    NULL};

char *Head2[] = {
    "/S {fontsize mul 780 exch sub 0 exch moveto show} def\n",
    "/P+ {/Save save def M concat} def\n",
    "/P- {showpage Save restore} def\n",
    NULL};

char *Mdef[] = {"/M [1 0 0 1 18 0] def \n", "/M [0 -.727 0.727 0 21 737] def\n"};


int	Choose();
long	start, end, bytes;
int	nobanner;			/* when true, disable banner flag */

int
main(int argc, char *argv[])
{
	int 	rc;
	unsigned	header_flags;
	char		ibuffer[32], *c;

	for(rc=0; rc < argc; rc++) {
	       	if(!strcmp(argv[rc],"-nobanner"))
		       	nobanner = 1;
	}
	if(nobanner && (c = getenv(TV_CFlags))) {	/* clear banner page flags */
	       header_flags = atoi(c);
	       header_flags &= ~TVCF_BANNER;	/* clear banner flag */	
	       sprintf(ibuffer,"%s=%u",TV_CFlags, header_flags);
	       setenv(ibuffer);
       }

	if(!Choose()) 
	       	return(RT_CHANGED_TAGS);	/* even if we didn't change the text, don't do banners */

	time(&start);
	Translate();
	time(&end);
	fprintf(STDERR,"Translated %ld input bytes, %ld output bytes in %d seconds\n",bytes, tellp(STDOUT), (int) end-start);
	return(RT_OK|RT_CHANGED_TEXT);
}


int
Choose()
{
	char	*c;
	char	buffer[1024];
	int	count;
	int	mode = 0;
	int	rc = 1;

	/* the choose function examines the input buffer, looking for the
	   first series of non-whitespace characters. If the first non
	   whitespace character set is not  %! then we know that this is
	   not a PostScript file. 
	*/
	seekp(STDIN, 0, SEEK_SET);

	count = read(STDIN, buffer, 1024);
	for(c=buffer; count > 0; count--, c++) {		/* into loop if char c is valid */
		if(isascii(*c) && isspace(*c))
			continue;
		switch( mode ) {

			case 0 :	/* looking for % */
				if(*c != '%') {
					rc = 1;
					goto out;
				}
				mode++;
				break;
			case 1 :	/* looking for ! */
				if(*c == '!') 
					rc = 0;
				else
				       	rc = 1;
				goto out;
		};
	}	/* end while */
out:;
	seekp(STDIN, 0, SEEK_SET);
	return(rc);	/* nothing but blanks so far */
}


int
Translate()
{
	int	x;
	char	*c;
	int	copies = 1;
	int	sequence;
	int	page = 0;
	int	fontsize;
	int 	LineNumFlag;
	int	rownum = 1;
	int	pagelength = 66;
	int	wide = 0;
	int	row;
	int	col = 0;
	int	writeptr;
	int	savec;
	char	line[MAX_LINE_LENGTH];
	char	ibuffer[BUFFSIZE];
	int	count;
	int	eof = 0;
	unsigned header_flags;

	bytes = 0;
	if(c = getenv(TV_CCopies)) {
		copies = atoi(c);
		if(!copies)
			copies = 1;
		sprintf(ibuffer,"%s=1",TV_CCopies);
		setenv(ibuffer);
	}
	for(x=0; Head1[x] != NULL; x++)
		write(STDOUT, Head1[x], strlen(Head1[x]));

	write(STDOUT, Mdef[wide], strlen(Mdef[wide]));

	fprintf(STDOUT,"/#copies %d def\n",copies);
	fprintf(STDOUT,"/fontsize %d def\n",FONTSIZE);
	/* select font here */
	fprintf(STDOUT,"/Courier ");

	fprintf(STDOUT,"findfont fontsize scalefont setfont\n");
	for(x=0; Head2[x] != NULL; x++) {
	       	write(STDOUT, Head2[x], strlen(Head2[x]));
	}

	row = rownum;
	while(!eof) {
	       	count = read(STDIN, ibuffer, BUFFSIZE);
		if(count == -1)
			break;
		if(count < BUFFSIZE)
		       	eof = 1;		/* next read will be end */
		bytes += count;
		for(c = ibuffer; count; count--, c++) {
			switch(*c) {

			        case -1 :
				case '\r':
					break;
				case '\n' :
				case '\f' :
leave:;
				       	if(*c == -1 && row == rownum)
					       	return(0);
					if(row == rownum) {
						page++;
						fprintf(STDOUT,"%%%%Page: ? %d\nP+\n",page);
					}
					if(col > 0) {
						line[col < MAX_LINE_LENGTH ? col : MAX_LINE_LENGTH] = 0;
						putstring(line);
						fprintf(STDOUT, "%d S\n", row);
					}
scan:;
					if(*c == '\n')
						row++;
					if(row == pagelength || *c == '\f' || *c == -1) {
						row = rownum;
						fprintf(STDOUT,"P-\n");
					}
					if(*c == -1) {
						return(0);
					}
					col = 0;
					break;
				case '\t' :
					while(col < MAX_LINE_LENGTH) {
						line[col++] = ' ';
						if(col % 8 == 0)
							break;
					}
					break;
				case '\b' :
					if(col)
						col--;
					break;
				default : 
					if(col < MAX_LINE_LENGTH)   
						line[col++] = isascii(*c) && isprint(*c) ? *c : ' ';
					break;
			} /* end c switch */

		} /* end for */
       }	/* end !eof */
	c = ibuffer;
	*c = -1;
	goto leave;

}

int
putstring(register char *s)
{
    register c;
    char	buffer[512];
    char	*x, *limit;

    x = buffer;
    limit = x + 509;

    *x++ = '(';
    while((c = *s++)!= '\0') {
         if(c=='\\' || c == '(' || c == ')')
		*x++ = '\\';
	  *x++ = c;
	  if(x > limit) {
		 	write(STDOUT, buffer, x - buffer);
			x = buffer;
	  }
    }
    *x++ = ')';
    write(STDOUT, buffer, x - buffer);
    return(0);
}




