###############################################################################
#
# File:         makefile
# RCS:          $Header: $
# Description:  Makefile for building Emacs under MSDOS with WATCOM C/386
# Author:       Darryl Okahata
# Created:      Fri Mar 19 20:10:28 1993
# Modified:     Wed Aug 18 23:08:22 1993 (darrylo@home) darrylo@hostigos
# Language:     N/A
# Package:      N/A
# Status:       Experimental (Do Not Distribute)
#
# (C) Copyright 1993, Darryl Okahata, all rights reserved.
#
###############################################################################

# Full pathname to WATCOM's wildargv.obj:
WATCOM_WILD=e:/watcom/src/startup/wildargv.obj

# TERMCAP_PATH=d:\usr\c\flat32\libs

# For debugging, use:
CFLAGS=  /d2 /Drcheck /Demacs /DDEBUG_EMACS /DHAVE_CONFIG_H
# For production code, use:
CFLAGS= /s /oilrtn /4r /zp4 /oe=60 /Demacs /DDEBUG_EMACS /DHAVE_CONFIG_H

###############################################################################

# Use the protected-mode compiler, with signed chars:
# CC=wcl386 /p /j		# For WATCOM C/386 9.0
CC=wcl386 /j /i=.

.c.obj:
	$(CC) /c $(CFLAGS) /fo=wat\$[*.obj $[*


dot = .
lispdir = $(dot)$(dot)/lisp/
etcdir = $(dot)$(dot)/etc/


# oemacs.s can't be in the following list
src=    dispnew.c frame.c scroll.c xdisp.c window.c \
	term.c cm.c \
	emacs.c keyboard.c macros.c keymap.c sysdep.c \
	buffer.c filelock.c insdel.c marker.c \
	interval.c textprop.c \
	minibuf.c fileio.c dired.c filemode.c \
	cmds.c casetab.c casefiddle.c indent.c search.c \
	regex.c undo.c \
	alloc.c data.c doc.c editfns.c callint.c \
	eval.c floatfns.c fns.c print.c lread.c \
	abbrev.c syntax.c unexec.c mocklisp.c bytecode.c \
	process.c callproc.c $(environobj) \
	doprnt.c getloada.c \
	dosfns.c pwd.c mktemp.c \
	pc-term.c pc-faces.c

obj=    wat/dispnew.obj wat/frame.obj wat/scroll.obj wat/xdisp.obj \
	wat/window.obj wat/term.obj wat/cm.obj \
	wat/emacs.obj wat/keyboard.obj wat/macros.obj wat/keymap.obj \
	wat/sysdep.obj \
	wat/buffer.obj wat/filelock.obj wat/insdel.obj wat/marker.obj \
	wat/interval.obj wat/textprop.obj \
	wat/minibuf.obj wat/fileio.obj wat/dired.obj wat/filemode.obj \
	wat/cmds.obj wat/casetab.obj wat/casefiddle.obj wat/indent.obj \
	wat/search.obj wat/regex.obj wat/undo.obj \
	wat/alloc.obj wat/data.obj wat/doc.obj wat/editfns.obj \
	wat/callint.obj \
	wat/eval.obj wat/floatfns.obj wat/fns.obj wat/print.obj wat/lread.obj \
	wat/abbrev.obj wat/syntax.obj wat/unexec.obj wat/mocklisp.obj \
	wat/bytecode.obj wat/process.obj wat/callproc.obj $(environobj) \
	wat/doprnt.obj wat/getloada.obj \
	wat/dosfns.obj wat/pwd.obj wat/director.obj wat/dpmi.obj \
	wat/mktemp.obj wat/fixpath.obj wat/link.obj wat/random.obj \
	wat/pc-term.obj wat/pc-faces.obj

termcapobj = wat/termcap.obj wat/tparam.obj

mallocobj = # wat/gmalloc.obj wat/vm-limit.obj # wat/alloca.obj

otherobj= wat/firstfil.obj $(termcapobj) wat/lastfile.obj $(mallocobj)

lisp= \
	..\lisp\abbrev.elc \
	..\lisp\buff-menu.elc \
	..\lisp\byte-run.elc \
	..\lisp\c-mode.elc \
	..\lisp\files.elc \
	..\lisp\fill.elc \
	..\lisp\float-sup.elc \
	..\lisp\help.elc \
	..\lisp\indent.elc \
	..\lisp\isearch.elc \
	..\lisp\lisp-mode.elc \
	..\lisp\lisp.elc \
	..\lisp\loaddefs.el \
	..\lisp\map-ynp.elc \
	..\lisp\page.elc \
	..\lisp\paragraphs.elc \
	..\lisp\paths.el \
	..\lisp\register.elc \
	..\lisp\replace.elc \
	..\lisp\simple.elc \
	..\lisp\startup.elc \
	..\lisp\subr.elc \
	..\lisp\text-mode.elc \
	..\lisp\vc-hooks.elc \
	..\lisp\window.elc \
	..\lisp\nonstd\oemacs.elc \
	..\lisp\nonstd\demacs.elc \
	..\lisp\nonstd\dos-fns.elc

all: wat temacs.exe doc .SYMBOLIC

wat:
	mkdir wat

doc:	$(etcdir)DOC .SYMBOLIC

$(etcdir)DOC: ..\lib-src\make-doc.exe $(obj) $(lisp)
	makedoc.bat

temacs.exe:   $(obj) $(otherobj) temacs.rsp
	wlinkp @temacs.rsp

wat/crt0.obj : crt0.c config.h
	$(CC) -c $(CFLAGS) -o wat/crt0.obj crt0.c

install:	temacs.exe ..\bin.wat .SYMBOLIC
	copy temacs.exe ..\bin.wat

clean:	.SYMBOLIC
	-del wat\*.obj
	-del *.err
	-del temacs.exe
	-del temacs.map

temacs.rsp:	makefile.wat
	echo name temacs.exe > temacs.rsp
	echo option map >> temacs.rsp
	echo debug all >> temacs.rsp
	echo option stack=500k >> temacs.rsp
	echo option dosseg >> temacs.rsp
	echo system dos4g >> temacs.rsp
	echo option caseexact >> temacs.rsp
	echo file wat/firstfil.obj >> temacs.rsp
	for %f in ($(obj)) do echo file %f >> temacs.rsp
	echo file wat/lastfile.obj >> temacs.rsp
	for %f in ($(termcapobj) $(mallocobj)) do echo file %f >> temacs.rsp

###############################################################################
# DEPENDENCIES (DO NOT CHANGE THIS LINE OR ANYTHING PAST IT)
wat/abbrev.o:	abbrev.c config.h lisp.h commands.h buffer.h window.h
wat/alloc.o:	alloc.c config.h lisp.h intervals.h puresize.h buffer.h window.h frame.h blockinput.h syssignal.h
wat/alloca.o:	alloca.c config.h
wat/buffer.o:	buffer.c config.h lisp.h intervals.h window.h commands.h buffer.h syntax.h indent.h blockinput.h
wat/bytecode.o:	bytecode.c config.h lisp.h buffer.h syntax.h
wat/callint.o:	callint.c config.h lisp.h buffer.h commands.h keyboard.h window.h mocklisp.h
wat/callproc.o:	callproc.c config.h lisp.h commands.h buffer.h paths.h process.h syssignal.h
wat/casefidd.o:	casefidd.c config.h lisp.h buffer.h commands.h syntax.h
wat/casetab.o:	casetab.c config.h lisp.h buffer.h
wat/cm.o:	cm.c config.h cm.h termhooks.h
wat/cmds.o:	cmds.c config.h lisp.h commands.h buffer.h syntax.h
wat/crt0.o:	crt0.c config.h
wat/data.o:	data.c config.h lisp.h puresize.h buffer.h syssignal.h
wat/director.o:	director.c dosdir.h dpmi.h
wat/dired.o:	dired.c config.h dosdir.h ndir.h lisp.h buffer.h commands.h regex.h
wat/dispnew.o:	dispnew.c config.h lisp.h termchar.h termopts.h termhooks.h cm.h dispextern.h buffer.h frame.h window.h commands.h disptab.h indent.h systty.h systime.h xterm.h
wat/doc.o:	doc.c config.h lisp.h buffer.h keyboard.h
wat/doprnt.o:	doprnt.c 
wat/dosfns.o:	dosfns.c config.h dpmi.h lisp.h frame.h buffer.h termchar.h dosfns.h pccompat.h
wat/dpmi.o:	dpmi.c dpmi.h
wat/dvxfns.o:	dvxfns.c config.h lisp.h blockinput.h xterm.h systime.h
wat/editfns.o:	editfns.c config.h pwd.h lisp.h intervals.h buffer.h window.h systime.h
wat/emacs.o:	emacs.c config.h lisp.h commands.h intervals.h systty.h syssignal.h termchar.h
wat/eval.o:	eval.c config.h lisp.h blockinput.h commands.h keyboard.h
wat/fileio.o:	fileio.c config.h lisp.h dosfns.h pwd.h config.h lisp.h intervals.h buffer.h window.h systime.h
wat/filelock.o:	filelock.c config.h pwd.h lisp.h paths.h buffer.h
wat/filemode.o:	filemode.c config.h
wat/firstfil.o:	firstfil.c 
wat/fixpath.o:	fixpath.c 
wat/floatfns.o:	floatfns.c config.h lisp.h syssignal.h
wat/fns.o:	fns.c config.h lisp.h commands.h buffer.h keyboard.h intervals.h
wat/frame.o:	frame.c config.h lisp.h frame.h buffer.h window.h termhooks.h commands.h keyboard.h
wat/getloada.o:	getloada.c config.h
wat/gmalloc.o:	gmalloc.c config.h lisp.h getpagesize.h
wat/hftctl.o:	hftctl.c 
wat/indent.o:	indent.c config.h lisp.h buffer.h indent.h frame.h window.h termchar.h termopts.h disptab.h
wat/insdel.o:	insdel.c config.h lisp.h intervals.h buffer.h window.h blockinput.h
wat/interval.o:	interval.c config.h lisp.h intervals.h buffer.h
wat/keyboard.o:	keyboard.c config.h termchar.h termopts.h lisp.h termhooks.h macros.h frame.h window.h commands.h buffer.h disptab.h dispextern.h keyboard.h intervals.h blockinput.h syssignal.h systty.h systime.h
wat/keymap.o:	keymap.c config.h lisp.h commands.h buffer.h keyboard.h termhooks.h blockinput.h
wat/lastfile.o:	lastfile.c 
wat/link.o:	link.c 
wat/lread.o:	lread.c config.h lisp.h buffer.h paths.h commands.h keyboard.h termhooks.h
wat/macros.o:	macros.c config.h lisp.h macros.h commands.h buffer.h window.h
wat/marker.o:	marker.c config.h lisp.h buffer.h
wat/minibuf.o:	minibuf.c config.h lisp.h commands.h buffer.h dispextern.h frame.h window.h syntax.h
wat/mktemp.o:	mktemp.c 
wat/mocklisp.o:	mocklisp.c config.h lisp.h buffer.h
wat/pc-faces.o:	pc-faces.c config.h lisp.h buffer.h dispextern.h frame.h window.h pc-term.h pc-rgb.h
wat/pc-term.o:	pc-term.c config.h lisp.h dispextern.h termhooks.h termopts.h termchar.h frame.h systime.h dosfns.h pccompat.h disptab.h pc-term.h
wat/pre-crt0.o:	pre-crt0.c 
wat/prefix-a.o:	prefix-a.c 
wat/print.o:	print.c config.h lisp.h buffer.h frame.h window.h process.h dispextern.h termchar.h intervals.h
wat/process.o:	process.c config.h systime.h systty.h lisp.h window.h buffer.h process.h termhooks.h termopts.h commands.h frame.h syssignal.h lisp.h systime.h termopts.h
wat/pwd.o:	pwd.c pwd.h
wat/ralloc.o:	ralloc.c config.h lisp.h config.h getpagesize.h
wat/random.o:	random.c 
wat/regex.o:	regex.c config.h lisp.h buffer.h syntax.h regex.h
wat/scroll.o:	scroll.c config.h termchar.h lisp.h dispextern.h frame.h
wat/search.o:	search.c config.h lisp.h syntax.h buffer.h commands.h blockinput.h regex.h
wat/sunfns.o:	sunfns.c config.h lisp.h window.h buffer.h termhooks.h
wat/syntax.o:	syntax.c config.h lisp.h commands.h buffer.h syntax.h
wat/sysdep.o:	sysdep.c config.h lisp.h blockinput.h systty.h frame.h window.h termhooks.h termchar.h termopts.h dispextern.h process.h ndir.h syssignal.h systime.h pccompat.h dosfns.h pccompat.h dpmi.h
wat/term.o:	term.c config.h termchar.h termopts.h cm.h lisp.h frame.h disptab.h termhooks.h keyboard.h
wat/termcap.o:	termcap.c config.h
wat/terminfo.o:	terminfo.c 
wat/textprop.o:	textprop.c config.h lisp.h intervals.h buffer.h
wat/tparam.o:	tparam.c config.h
wat/undo.o:	undo.c config.h lisp.h buffer.h
wat/unexec.o:	unexec.c config.h getpagesize.h
wat/vm-limit.o:	vm-limit.c config.h lisp.h mem-limits.h
wat/window.o:	window.c config.h lisp.h buffer.h frame.h window.h commands.h indent.h termchar.h disptab.h keyboard.h
wat/xdisp.o:	xdisp.c config.h lisp.h frame.h window.h termchar.h dispextern.h buffer.h indent.h commands.h macros.h disptab.h termhooks.h
wat/xfaces.o:	xfaces.c config.h lisp.h xterm.h buffer.h dispextern.h frame.h blockinput.h window.h
wat/xfns.o:	xfns.c config.h lisp.h xterm.h frame.h window.h buffer.h dispextern.h keyboard.h blockinput.h bitmaps/gray.xbm
wat/xmenu.o:	xmenu.c config.h lisp.h frame.h window.h keyboard.h blockinput.h xterm.h dispextern.h ../oldXMenu/XMenu.h
wat/xrdb.o:	xrdb.c config.h
wat/xselect.o:	xselect.c config.h lisp.h termhooks.h xterm.h dispextern.h frame.h blockinput.h
wat/xterm.o:	xterm.c config.h lisp.h blockinput.h xterm.h systty.h systime.h dispextern.h termhooks.h termopts.h termchar.h sink.h sinkmask.h gnu.h frame.h disptab.h buffer.h window.h
