/* -*-C-*-
*******************************************************************************
*
* File:         pccompat.h
* RCS:          $Header: $
* Description:  PC Compatibity routines and header info.
*		This file assists in porting software between WATCOM C/386
*		and DJGPP, among other things.
* Author:       Darryl Okahata
* Created:      Sun Jun 27 18:38:35 1993
* Modified:     Sun Jul 11 00:50:26 1993 (darrylo@home) darrylo@hostigos
* Language:     C
* Package:      N/A
* Status:       Experimental
*
* (C) Copyright 1993, Darryl Okahata, all rights reserved.
*
*******************************************************************************
*/


#define M_Shift_L    0x01
#define M_Shift_R    0x02
#define M_Control    0x04
#define M_Alt	     0x08
#define M_ScrollLock 0x10
#define M_NumLock    0x20
#define M_CapsLock   0x40
#define M_Ins        0x80


#ifdef __WATCOMC__
# define REGS_TYPE		union REGS

# define REGISTER_AX(r)		((r).w.ax)
# define REGISTER_BX(r)		((r).w.bx)
# define REGISTER_CX(r)		((r).w.cx)
# define REGISTER_DX(r)		((r).w.dx)
# define REGISTER_SI(r)		((r).w.si)
# define REGISTER_DI(r)		((r).w.di)

# define REGISTER_AH(r)		((r).h.ah)
# define REGISTER_AL(r)		((r).h.al)
# define REGISTER_BH(r)		((r).h.bh)
# define REGISTER_BL(r)		((r).h.bl)
# define REGISTER_CH(r)		((r).h.ch)
# define REGISTER_CL(r)		((r).h.cl)
# define REGISTER_DH(r)		((r).h.dh)
# define REGISTER_DL(r)		((r).h.dl)

# define INT(i,ir,or)		(int386((i),(ir),(or)))

extern short *ScreenPrimary;

# define FINDFIRST(a,b,c)	_dos_findfirst((a),(c),(b))
# define FFTYPE			struct find_t
# define FFATTRIB(f)		((f).attrib)
# define FFTIME(f)		((f).wr_time)
# define FFDATE(f)		((f).wr_date)
# define FFSIZE(f)		((f).size)
# define FFNAME(f)		((f).name)

# define FFNORMAL		_A_NORMAL
# define FFRDONLY		_A_RDONLY
# define FFHIDDEN		_A_HIDDEN
# define FFSYSTEM		_A_SYSTEM
# define FFLABEL		_A_VOLID
# define FFDIREC		_A_SUBDIR
# define FFARCH			_A_ARCH

#endif	/* __WATCOMC__ */

#ifdef __GO32__
# define REGS_TYPE		union REGS

# define REGISTER_AX(r)		((r).x.ax)
# define REGISTER_BX(r)		((r).x.bx)
# define REGISTER_CX(r)		((r).x.cx)
# define REGISTER_DX(r)		((r).x.dx)
# define REGISTER_SI(r)		((r).x.si)
# define REGISTER_DI(r)		((r).x.di)

# define REGISTER_AH(r)		((r).h.ah)
# define REGISTER_AL(r)		((r).h.al)
# define REGISTER_BH(r)		((r).h.bh)
# define REGISTER_BL(r)		((r).h.bl)
# define REGISTER_CH(r)		((r).h.ch)
# define REGISTER_CL(r)		((r).h.cl)
# define REGISTER_DH(r)		((r).h.dh)
# define REGISTER_DL(r)		((r).h.dl)

# define INT(i,ir,or)		(int86((i),(ir),(or)))

# define FINDFIRST(a,b,c)	findfirst((a),(b),(c))
# define FFTYPE			struct ffblk
# define FFATTRIB(f)		((f).ff_attrib)
# define FFTIME(f)		((f).ff_ftime)
# define FFDATE(f)		((f).ff_fdate)
# define FFSIZE(f)		((f).ff_fsize)
# define FFNAME(f)		((f).ff_name)

# define FFNORMAL		(0)
# define FFRDONLY		FA_RDONLY
# define FFHIDDEN		FA_HIDDEN
# define FFSYSTEM		FA_SYSTEM
# define FFLABEL		FA_LABEL
# define FFDIREC		FA_DIREC
# define FFARCH			FA_ARCH

#endif	/* __GO32__ */
