/*-------------------------------------------------------
   DRUMDLL.H header file for DLL module for DRUM program
  -------------------------------------------------------*/

#define NUM_PERC         47
#define WM_USER_NOTIFY   (WM_USER + 1)
#define WM_USER_FINISHED (WM_USER + 2)
#define WM_USER_ERROR    (WM_USER + 3)

typedef struct
     {
     int   iMsecPerBeat ;
     int   iVelocity ;
     int   iNumBeats ;
     DWORD dwSeqBas [NUM_PERC] ;
     DWORD dwSeqExt [NUM_PERC] ;
     }
     DRUM ;

typedef DRUM FAR *PDRUM ;

extern "C"
     {
void FAR PASCAL _export DrumSetParams     (PDRUM) ;
BOOL FAR PASCAL _export DrumBeginSequence (HWND)  ;
void FAR PASCAL _export DrumEndSequence   (BOOL)  ;
     }
