;PeekPoke.ASM
;Copyright (c) 1992 Jay Munro
;First published in PC Magazine June 16,1992

;Syntax
;  Declare Function Peek%(Byval SegSelector%, Byval Offset%)
;  LptPortAddress% = Peek%(GetAbs%(&h0040),&h0) + (256 * Peek%(GetAbs%(&h0040),&h1)
;
;  Declare Sub Poke(Byval SegSelector%, Byval Offset%, Byval DataByte%)
;  Call Poke(GetAbs%(&hB800),0,65)              ;put an A on a second monitor.
;
;----------------------------------------------------------------------------
;  Peek and Poke are replacements (or add ons) for Visual Basic and operate
;  in a similar way to QuickBasic.  The difference is that VB doesn't have a
;  Def Seg, so we must pass the segment ( or selector) to the routine.   The
;  routines check the selector to see if it has read or write privileges to
;  avoid getting a trap 13 error (or UAE) in Windows.  The Peek routine
;  returns an 2 byte integer, but only one byte is used to remain compatible
;  with QuickBasic.  To modify it to return a full word, delete the Xor AH,AH
;  near the end of the routine.

;  Poke takes an integer parameter, but only uses the low byte portion in
;  storing the byte.  The AL register can be modified to AX for word storage.
;----------------------------------------------------------------------------

.286P
.Model Medium
    Include LabNotes.Inc
    Public Peek, Poke
    
.Code

Peek Proc Far
    ShortWinProlog              ;DS not used
    Verr Word Ptr [BP+8]                 ;check selector for readability
    Jz   @F                     ;yes, continue
    Mov  AX,-1                  ;no, exit with -1
    Jmp  Exit
@@:
    Push DS                     ;save DS
    Lds  BX,[BP+6]              ;get segment:offset to Peek
    Mov  AL,[BX]                ;get byte from memory
    Pop  DS                     ;restore DS
    Xor  AH,AH                  ;clear AH to return 1 byte
Exit:
    ShortWinEpilog              ;restore stack to original
    Ret  4                      ;
Peek EndP

Poke Proc Far
    ShortWinProlog              ;DS not used
    Verw Word Ptr [BP+10]       ;check segment for writability
    Jz   @F                     ;zero set, must be good
    Mov  AX,-1                  ;zero not, jump out with -1
    Jmp  PokeExit
@@:
    Push DS                     ;save DS
    Lds  BX,[BP+8]              ;get address to poke
    Mov  AX,[BP+6]              ;get data byte
    Mov  [BX],AL                ;store byte
    Pop  DS                     ;retrieve DS

PokeExit:
    ShortWinProlog
    Ret  6
Poke EndP

End
    
