/* OBJWND.C -- "object windows" from WMHANDLER */

#include "windows.h"
#include "objwnd.h"

static WMHANDLER wmhandler[WM_USER] = {0};

#define MAX_EXTRA	32

typedef struct {
	WORD message;
	WMHANDLER handler;
	} EXTRAHANDLER;

static EXTRAHANDLER extrahandler[MAX_EXTRA] = {0};
static int num_extra = 0;

static int isextramsg(WORD message)
{
	EXTRAHANDLER *pex;
	int i;
	for (i=0, pex=extrahandler; i<MAX_EXTRA; i++, pex++)
		if (pex->message == message)
			return i;
	return -1;
}

static long defwmhandler(HWND hwnd, WORD msg, WORD wParam, LONG lParam)
{   
    return DefWindowProc(hwnd, msg, wParam, lParam);
}

static BOOL did_init = FALSE;
void objwnd_init(void)
{
	EXTRAHANDLER *pex;
    WMHANDLER *pwm;
    int i;
    for (i=0, pwm=wmhandler; i < WM_USER; i++, pwm++) 
        *pwm = defwmhandler;
	for (i=0, pex=extrahandler; i < MAX_EXTRA; i++, pex++)
	{
		pex->message = 0;
		pex->handler = defwmhandler;
	}
	did_init = TRUE;
}

long FAR PASCAL _export WndProc(HWND hWnd, WORD message, 
    WORD wParam, LONG lParam)
{
	int iExtraMsg;
	
    if (message < WM_USER)
        return (*wmhandler[message])(hWnd, message, wParam, lParam);
    else if ((iExtraMsg = isextramsg(message)) != -1)
		return (*extrahandler[iExtraMsg].handler)(hWnd, 
			message, wParam, lParam);
	else
        return DefWindowProc(hWnd, message, wParam, lParam);
}

WMHANDLER on(unsigned message, WMHANDLER f)
{
    WMHANDLER oldf;
	int iExtraMsg;
	
	if (! did_init)	
		objwnd_init();
        
    if (message < WM_USER)
    {
        oldf = wmhandler[message];
        wmhandler[message] = f ? f : defwmhandler;
        return (oldf) ? oldf : defwmhandler;
    }
    else if ((iExtraMsg = isextramsg(message)) != -1)
	{
		oldf = extrahandler[iExtraMsg].handler;
		extrahandler[iExtraMsg].handler = f ? f : defwmhandler;
		return (oldf) ? oldf : defwmhandler;
	}
	else if (num_extra < MAX_EXTRA)
	{
		extrahandler[num_extra].message = message;
		extrahandler[num_extra].handler = f;
		num_extra++;
		return defwmhandler;
	}
	else
        return -1;	// couldn't set!
}

HWND objwnd(HANDLE hPrevInst, HANDLE hInst, char *name)
{
    static HWND hwnd = 0;
    
    if (hwnd)		
		return hwnd;
	
	if (! did_init)	
		objwnd_init();
        
    if (! hPrevInst)
    {
        WNDCLASS wndclass;
        memset(&wndclass, 0, sizeof(wndclass));
        wndclass.lpfnWndProc = WndProc;
        wndclass.hInstance = hInst;
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
        wndclass.lpszClassName = "OBJECTWND";
        if (! RegisterClass(&wndclass))
            return 0;
    }
    
    hwnd = CreateWindow("OBJECTWND", name, 
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, 
        NULL, NULL, hInst, NULL);
    return hwnd;
}

int mainloop(void)
{
    MSG msg;
    while (GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return msg.wParam;
}

void yield(void)
{
    MSG msg;
    if (GetMessage(&msg, NULL, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
}

