/* WINCLIP.H -- DOS access to Windows Clipboard (Enhanced mode) */

#ifdef METAWARE
#define far _far
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* higher-level functions */

int WindowsClipboard(void);
int Clipserv(void);
int PutClipStrLen(char *str, unsigned len);
int PutClipString(char *str);
char *GetClipString(void);
void FreeClipString(char *str);

/**********************************************************************/

/* lower-level functions */

typedef enum { 
    CF_TEXT=1, CF_BITMAP=2, CF_METAFILEPICT=3, CF_SYLK=4,
    CF_DIF=5, CF_TIFF=6, CF_OEMTEXT=7
    } CF_FORMAT;

#pragma pack(1)

typedef struct {
    int                 bmType;
    int                 bmWidth;
    int                 bmHeight;
    int                 bmWidthBytes;
    unsigned char       bmPlanes;
    unsigned char       bmBitsPixel;
    unsigned char far * bmBits;
    unsigned            bmWidDim;
    unsigned            bmHigDim;
    unsigned char       BitmapData[1];
    } BITMAP;

typedef struct {
    int                 mm;
    int                 xExt;
    int                 yExt;
    unsigned char       MetaFilePictData[1];
  } METAFILEPICT;

unsigned long CompactClipboard(unsigned long size);
unsigned CloseClipboard(void);
unsigned EmptyClipboard(void);
unsigned char far *GetClipboardData(CF_FORMAT format, 
    unsigned char far *buf);
unsigned long GetClipboardDataSize(CF_FORMAT format);
unsigned GetDeviceCaps(unsigned index);
unsigned IdentifyWinOldApVersion(void);
unsigned OpenClipboard(void);
unsigned SetClipboardData(CF_FORMAT format, unsigned char far *buf, 
    unsigned long size);
void Yield(void);

#ifdef __cplusplus
}
#endif

