        TARGET EQU 0D8H 
        SOURCE EQU 0B0H
CODE_SEG        SEGMENT
        ASSUME  CS:CODE_SEG,DS:CODE_SEG,ES:CODE_SEG
        ORG     100H
START:  JMP     DIREX
        PROMPT DB 'D=Delete P=Protect U=Unprotect C=Copy <Space>=Mark'
               DB ' N=New Dir Q=Quit$'
        COPY_PROMPT     DB      'Pathname to copy marked files to: $'
        NEW_DIR_PROMPT  DB      'New Pathname: $'
        FULL_MSG        DB      '*        TARGET DISK FULL!          *$'
        DEL_MSG         DB      'Delete Marked Files (Y/N)? $'
        COPY_FLAG       DB      0       ;Set when doing copies.
        D1_FLAG         DB      0       ;In DISPLAY, not DSPLAY@
        DISP_FLAG       DB      0       ;Set when intial display done.
        FULL_FLAG       DB      0       ;Disk Full Flag.
        NOFILE_FLAG     DB      0       ;1-->No filename given.
        SOURCE_HANDLE   DW      0       ;Source File Handle.
        TARGET_HANDLE   DW      0       ;Target File Handle.
        SOURCE_PATH_END DW      0B0H    ;End of Path -- put filenames here.
        TARGET_PATH_END DW      0DBH    ;Same for Target.
        TEST_PATH_END   DW      0       ;Same for Target.
        BYTES_READ      DW      ?       ;Bytes read -- for copy.
        BYTES_ASKED     DW      ?       ;Bytes requested to be read.
        MARKED  DB      ?               ;File Marked? 
        ATTRIB  DB      7               ;Screen Attribute.
        WILDCARDS       DB      '*.*',0
        CURSOR_X        DB      ?       ;Reverse Vid. Cursor position X
        CURSOR_Y        DB      ?       ;Same for Y.
        TEMPX           DB      ?       ;Temporary storage for x,y positions.
        TEMPY           DB      ?
        FILENAME        DB      10 DUP(0)       ;Store given filname here.
                        DB  "Copyright 1986 Ziff-Davis Publishing Co.",1Ah
	                DB  "Programmed by Steven Holzner",1Ah



DIREX   PROC    NEAR
        CALL    DISPLAY                 ;Setup -- put dir on screen.
        MOV     SI,SOURCE_PATH_END      ;Light up first filename.
        CALL    GET_FILE_NAME
TOPPER: MOV     ATTRIB,70H
        CALL    COLOR
TOP:    MOV     AH,0                    ;Read a character w/o echo.
        INT     16H

SPACE:  CMP     AL,20H                  ;Space? Mark a file?
        JNE     RIGHT                   ;No, check cursor keys
        MOV     AH,8                    ;Yes.
        MOV     BX,0                    ;Check if file marked.
        ADD     CURSOR_X,12             ;Read byte just after filname
        CALL    SET_CURSOR              ; from the screen.
        INT     10H                     
        CMP     AL,0FFH                 ;Marked? (Yes if FFH)
        JE      OPP                     ;Yes.
        MOV     AL,0FFH                 ;No, mark.
        JMP     PPO
OPP:    MOV     AL,0                    ;Unmark, move 0 to last byte.
PPO:    MOV     AH,10
        MOV     CX,1
        INT     10H
        SUB     CURSOR_X,12             ;Reset cursor to beginning of filename.
        CALL    SET_CURSOR
        JMP     TOP                     ;And start over.

RIGHT:  CMP     AH,4DH                  ;Right cursor key?
        JNE     LEFT                    ;No, try left.
        MOV     ATTRIB,7                ;Unmark current file if we can.
        CALL    COLOR
        CALL    INC_CURSOR              ;Move to next filename.
        MOV     ATTRIB,70H 
        CALL    COLOR                   ;And highlight it.
        JMP     TOP                     ;Start over.

LEFT:   CMP     AH,4BH                  ;Left cursor key?
        JNE     UP                      ;No, try up key.
        MOV     DL,CURSOR_X             ;Yes, move one filename left.
        MOV     DH,CURSOR_Y
        MOV     ATTRIB,7                ;First unmark current filename.
        CALL    COLOR
        SUB     DL,13
        JNC     OK                      ;Can we move left?
        MOV     DL,5*13                 ;No, wrap back.
        SUB     DH,1
        JNC     OK                      ;Make sure not over top of screen.
        MOV     DL,CURSOR_X             ;If so, do not change marked file.
        MOV     DH,CURSOR_Y
OK:     MOV     CURSOR_X,DL
        MOV     CURSOR_Y,DH             ;Load changed cursor positions
        CALL    SET_CURSOR              ; and light up new filename.
        MOV     ATTRIB,70H
        CALL    COLOR
        JMP     TOP                     ;And start over.

UP:     CMP     AH,48H                  ;An Up key?
        JNE     DOWN                    ;No, try down.
        MOV     DL,CURSOR_X             ;Yes, get highlit position.
        MOV     DH,CURSOR_Y
        MOV     ATTRIB,7                ;Unmark current filename.
        CALL    COLOR
        SUB     DH,1                    ;Can we go up?
        JNC     NOTTOP                  ;Yes.
        ADD     DH,1                    ;No.
NOTTOP: MOV     CURSOR_X,DL             ;Set new cursor position.
        MOV     CURSOR_Y,DH
        CALL    SET_CURSOR
        MOV     ATTRIB,70H              ;And highlight new filename.
        CALL    COLOR
        JMP     TOP                     ;And start over.

DOWN:   CMP     AH,50H                  ;Was this a down cursor key?
        JNE     LETTERS                 ;No, try letters (C,N,D,U,P)
        MOV     ATTRIB,7                ;Yes, unmark current filename.
        CALL    COLOR
        INC     CURSOR_Y                ;Are we past bottom if we INC Y?
        CALL    SET_CURSOR
        MOV     SI,SOURCE_PATH_END
        CALL    GET_FILE_NAME
        CMP     BYTE PTR DS:[SI],' '    ;Is there a filename there?
        JA      GO                      ;If yes, go.
NOGO:   DEC     CURSOR_Y                ;If no, retain old position.
        CALL    SET_CURSOR
GO:     MOV     ATTRIB,70H
        CALL    COLOR                   ;Highlight this file.
        JMP     TOP

LETTERS:CMP     AL,'Z'                  ;Convert to lower case
        JL      GOL
        SUB     AL,'a'-'A'
GOL:    CMP     AL,'Q'                  ;Is this a 'Q' to quit?
        JNE     DEL                     ;No, try 'D'.
        MOV     CX,25                   ;Clear the screen.
        MOV     CURSOR_X,0              
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR              
WIPE2:  PUSH    CX                      
        CALL    SET_CURSOR
        MOV     CX,80
        MOV     AH,9                    ;Use Service 9
        MOV     BX,7
        MOV     AL,0
        INT     10H                     ;With INT 10H.
        POP     CX
        INC     CURSOR_Y                ;Keep going on this line.
        LOOP    WIPE2                   ;Loop over all 25 lines.
        MOV     CURSOR_X,0              
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR              
        JMP     OUT                     ;Quit.

DEL:    CMP     AL,'D'                  ;Is this a 'D'?
        JE      OKD                     ;Yes.
        JMP     PRO                     ;No, Try 'P'.
OKD:    MOV     ATTRIB,7
        CALL    COLOR                   ;Unhighlight current filename.
        MOV     CURSOR_X,0
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR              ;Reset cursor to beginning.
        MOV     AH,9
        MOV     CX,80                   ;Print Del prompt.
        MOV     AL,' '                  ;First, clear prompt line.
        MOV     BX,7
        INT     10H
        MOV     CURSOR_X,0
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR
        MOV     AH,9
        MOV     DX,OFFSET DEL_MSG
        INT     21H
        MOV     AH,1                    ;Get a response.
        INT     21H                     ;Convert to upper case.
        CMP     AL,'Z'
        JL      CHECKY
        SUB     AL,'a'-'A'
CHECKY: CMP     AL,'Y'                  ;Was this a 'Y'?
        JE      GODEL                   ;Yes, Delete!
        CALL    DSPLAY2                 ;No, highlight current file and 
        MOV     ATTRIB,70H              ; start over.
        CALL    COLOR
        JMP     TOP
GODEL:  MOV     CURSOR_X,0              ;Delete here.
        MOV     CURSOR_Y,0              ;Start at beginning.
        CALL    SET_CURSOR
LOOPD:  CALL    GET_MARKED_FILE         ;Loop over all marked files.
        MOV     DX,SOURCE               ;Point to source string.
        MOV     AH,41H                  ;Delete!
        INT     21H
        CALL    INC_CURSOR              ;Move to next file.
        CMP     DX,0FFH                 ;Is there one?
        JE      FIND                    ;Yes.
        CMP     CX,0FFH                 ;No, start over, refresh display.
        JNE     LOOPD
FIND:   CALL    DSPLAY2
        MOV     ATTRIB,70H              ;Highlight first file.
        CALL    COLOR
        JMP     TOP
PRO:    CMP     AL,'P'                  ;Is this a 'P'?
        JNE     UNPRO                   ;No, try 'U'.
        MOV     ATTRIB,7                ;Yes, Unhighlight current file.
        CALL    COLOR
        MOV     CURSOR_X,0              ;Start at beginning of all files.
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR
LOOPP:  CALL    GET_MARKED_FILE         ;Loop over all marked files.
        MOV     DX,SOURCE
        MOV     AH,43H                  ;And Protect them.
        MOV     AL,01
        MOV     CX,1
        INT     21H
        CALL    INC_CURSOR              ;Move on to next filename.
        CMP     DX,0FFH                 ;If there is one.    
        JE      FINP                    ;If not, leave.
        CMP     CX,0FFH
        JNE     LOOPP                   ;If so, loop again.
FINP:   CALL    DSPLAY2                 ;Refresh screen.
        MOV     ATTRIB,70H              ;And highlight the first filename.
        CALL    COLOR
        JMP     TOP                     ;And start over.
UNPRO:  CMP     AL,'U'                  ;Was this a 'U'?
        JNE     COPY                    ;No, try 'C' for Copy.
        MOV     ATTRIB,7                ;Yes, unhighlight current file.
        CALL    COLOR
        MOV     CURSOR_X,0              ;Start at beginning of all files.
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR
LOOPU:  CALL    GET_MARKED_FILE         ;Loop over all marked files.
        MOV     DX,SOURCE               ;Point to found file.
        MOV     AH,43H                  ;And Unprotect it.
        MOV     AL,01
        MOV     CX,0                    ;CX=0 --> Unprotect.
        INT     21H
        CALL    INC_CURSOR              ;Point to next filename.
        CMP     DX,0FFH                 ;If there is one.
        JE      FINU                    ;If not, refresh screen and start over.
        CMP     CX,0FFH
        JNE     LOOPU
FINU:   CALL    DSPLAY2                 ;Refresh screen.
        MOV     ATTRIB,70H              ;Highlight first file.
        CALL    COLOR                   ;And start over.
        JMP     TOP
COPY:   CMP     AL,'C'                  ;Was this a 'C'?
        JE      GOC                     ;Yes, Copy!
        JMP     NEW_DIR                 ;No, try 'N' for New directory.
GOC:    MOV     FULL_FLAG,0             ;Set Disk full flag to false.
        MOV     ATTRIB,7                ;Unhighlight current file
        CALL    COLOR                   ; if we can.
        MOV     CURSOR_X,0              ;Type out copy prompt.
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR              ;First, clear prompt line.
        MOV     AH,9
        MOV     CX,80
        MOV     AL,' '
        MOV     BX,7
        INT     10H
        MOV     CURSOR_X,0
        MOV     CURSOR_Y,24             ;Type out copy prompt.
        CALL    SET_CURSOR
        MOV     AH,9                    ;With the string printing service.
        MOV     DX,OFFSET COPY_PROMPT   ;Ask for new pathname.
        INT     21H
        MOV     AH,0AH                  ;Put it at TARGET location.
        MOV     BX,TARGET-2             ;With a buffered read-in.
        MOV     DX,TARGET-2
        MOV     BYTE PTR [BX],32        ;32 bytes max.
        INT     21H
        MOV     SI,TARGET               ;Check now for final '\'.
TRANS:  CMP     BYTE PTR [SI],13        ;If it is missing, put it in.
        JE      SLASH2
        INC     SI
        JMP     TRANS
SLASH2: CMP     BYTE PTR [SI-1],'\'     ;Was a '\' at the end?
        JE      FILER2                  ;Yes.
        MOV     BYTE PTR [SI],'\'       ;Put '\' in at end of pathname.
        INC     SI
FILER2: MOV     TARGET_PATH_END,SI      ;Store end of pathname so we
        MOV     ATTRIB,7                ; can put filenames at end of it.
        CALL    COLOR                   ;Unhighlight current file if we can.
        MOV     CURSOR_X,0
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR
LOOPC:  MOV     COPY_FLAG,1             ;Set Copy flag (so GET_MARKED_FILE
        CALL    GET_MARKED_FILE         ; will fill in TARGET too).
        MOV     COPY_FLAG,0             ;Loop over all marked files.
        CMP     CX,0FFH                 ;If there are any.
        JNE     OPEN
        JMP     FINC
OPEN:   MOV     DX,SOURCE               ;Now to open source and target.
        MOV     AX,3D00H
        INT     21H
        JC      BOTC                    ;Unless there is an error.
        MOV     SOURCE_HANDLE,AX        ;Open source, store handle.
        MOV     DX,TARGET               ;Open target.
        MOV     AH,3CH
        MOV     CX,0
        INT     21H
        JC      BOTC
        MOV     TARGET_HANDLE,AX        ;And store its handle too.
STUFF:  MOV     DX,OFFSET DATA          ;We will use the end of the prog
        MOV     CX,61*1024              ; for data. 62K at once.
        MOV     AH,3FH                  ;Prepare to read in as much as we can.
        MOV     BX,SOURCE_HANDLE        ;From the source.
        INT     21H
        MOV     BYTES_READ,AX           ;How much was actually read?
        MOV     CX,AX                   ;Put # bytes read into CX for write.
        MOV     BYTES_ASKED,CX          ;Store to check later.
        MOV     AH,40H                  ;Here's the write!
        MOV     BX,TARGET_HANDLE        ;Get target handle.
        MOV     DX,OFFSET DATA          ;Point DS:DX.
        INT     21H
        CMP     AX,BYTES_ASKED          ;See if bytes written agrees with what 
        JNE     FULL                    ; what was asked. If not, full disk.
        CMP     BYTES_READ,61*1024      ;If OK, did we actually get 62K?
        JE      STUFF                   ;If so, go back for more.
        JMP     BOTC                    ;If not, done with this file, close.
FULL:   MOV     CURSOR_X,0              ;Here the disk is full, put up message.
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR
        LEA     DX,FULL_MSG
        MOV     AH,9
        INT     21H
        MOV     FULL_FLAG,1             ;Close files, set flag so we can delete
        MOV     CURSOR_X,0              ; partially copied file in Target.
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR              ;Move cursor back to top.
BOTC:   MOV     AH,3EH                  ;Close files.
        MOV     BX,SOURCE_HANDLE
        INT     21H
        MOV     AH,3EH                  ;Using Service 3EH.
        MOV     BX,TARGET_HANDLE
        INT     21H
        CMP     FULL_FLAG,1             ;Was this a disk-full case?
        JNE     NOTFULL                 ;No, do another file.
        MOV     DX,TARGET               ;Yes, now that files are closed, delete
        MOV     AH,41H                  ; partially copied file in target 
        INT     21H                     ; pathname.
        JMP     TOPPER                  ;Go back to top but don't wipe out Disk
NOTFULL:CALL    INC_CURSOR              ; Full message.
        CMP     DX,0FFH                 ;Point to next file if there is one.
        JE      FINC                    ;There isn't, finish up copy.
        JMP     LOOPC                   ;There is, start next copy.
FINC:   CALL    DSPLAY2                 ;Refresh screen.
        MOV     ATTRIB,70H              ;Highlight first file.
        CALL    COLOR
        JMP     TOP                     ;And start over.
NEW_DIR:CMP     AL,'N'                  ;Was this a 'N'? New Dir?
        JE      GON                     ;Yes.
        JMP     TOP                     ;No, ignore whatever was typed.
GON:    MOV     ATTRIB,7                ;Unhighlight current filename
        CALL    COLOR                   ; if we can (can't if marked).
        MOV     CURSOR_X,0
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR              ;Get set for 'New Dir: ' prompt.
        MOV     AH,9                    ;Use String Print Service.
        MOV     CX,80                   ;First clear prompt line.
        MOV     AL,' '
        MOV     BX,7
        INT     10H                     ;Using INT 10H.
        MOV     CURSOR_X,0
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR
        MOV     AH,9                    ;Print out New Dir prompt here.
        MOV     DX,OFFSET NEW_DIR_PROMPT
        INT     21H
        MOV     AH,0AH                  ;Now use buffered input to beginning
        MOV     BX,80H                  ; of DTA (where the first pathname
        MOV     DX,80H                  ; went anyway).
        MOV     BYTE PTR [BX],32        ;32 bytes max.
        INT     21H
        JMP     DIREX                   ;And start ALL over.
OUT:    INT     20H                     ;Finish for 'Q'.
DIREX   ENDP

GET_MARKED_FILE PROC    NEAR    ;This sets up SOURCE and TARGET.
        ;CX=FF --> No more to be found.
BEGI:   MOV     AH,8            ;Prepare to read mark byte from screen.
        ADD     CURSOR_X,12     ;Right after the filename -- in screen
        CALL    SET_CURSOR      ; buffer!
        MOV     BX,0
        INT     10H             ;Read mark byte.
        SUB     CURSOR_X,12     ;And immediately reset cursor.
        CALL    SET_CURSOR
        CMP     AL,0FFH         ;Is this file marked?
        JE      FINI            ;Yes, have found it, return.
        CALL    INC_CURSOR      ;No, check next file.
        CMP     DX,0FFH         ;Any more files left to check?
        JNE     BEGI            ;Yes, loop again.
        MOV     CX,0FFH         ;No, no more to be found, set the flag.
        JMP     OUTER           ;And exit.
FINI:   MOV     CX,0            ;Set CX=0 --> more available.
        MOV     SI,SOURCE_PATH_END
        CALL    GET_FILE_NAME   ;Set up SOURCE.
        CMP     COPY_FLAG,1     ;Is this a copy? Should we set up TARGET too?
        JNE     OUTER           ;No.
        MOV     SI,TARGET_PATH_END  ;Yes.
        CALL    GET_FILE_NAME
OUTER:  RET                     ;And return.
GET_MARKED_FILE ENDP

GET_FILE_NAME   PROC    NEAR
        ;Call with DS:SI as address to put filename at.
        PUSH    CX              ;Push what is used.
        PUSH    SI
        PUSH    WORD PTR CURSOR_X
        MOV     AH,8            ;Prepare to read from screen.
        MOV     BX,0
        MOV     CX,12           ;Twelve possible letters.
LOOPB:  MOV     AH,8            ;Loop and read 'em.
        INT     10H
        INC     CURSOR_X        ;Move to next screen position.
        CALL    SET_CURSOR
        MOV     DS:[SI],AL      ;Store this byte at location we are supposed 
        INC     SI              ; to build filename at.
        LOOP    LOOPB           ;Loop again until done.
        MOV     BYTE PTR DS:[SI],0      ;Make it an ASCIIZ string.
        POP     WORD PTR CURSOR_X       ;And now restore all.
        POP     SI
        CALL    SET_CURSOR
        POP     CX
        RET                     ;Return to calling program.
GET_FILE_NAME   ENDP

COLOR   PROC    NEAR            ;Highlights and Unhighlights filenames.
        PUSH    CX              ;If file is marked, will NOT Unhighlight.
        PUSH    WORD PTR CURSOR_X
        MOV     CX,12           ;Twelve characters in filename.
        CMP     ATTRIB,7        ;Are we unmarking?
        JNE     HERE            ;No.
        MOV     AH,8            ;Yes, check if file is marked.
        ADD     CURSOR_X,12     ;Read in mark byte from screen directly.
        CALL    SET_CURSOR
        MOV     BX,0
        INT     10H
        SUB     CURSOR_X,12     ;And reset cursor at once.
        CALL    SET_CURSOR
        CMP     AL,0FFH         ;Was this a marked file?
        JE      FINE            ;Yes, leave w/o unmarking.
HERE:   MOV     BX,0            ;No, move new ATTRIB into place.
        MOV     AH,8            ;Prepare to write to screen.
        INT     10H
        PUSH    CX
        MOV     CX,1
        MOV     BL,ATTRIB       ;Write with attribute ATTRIB.
        MOV     AH,9            ;With Service 9.
        INT     10H
        POP     CX
        INC     CURSOR_X        ;Move on to next letter.
        CALL    SET_CURSOR
        LOOP    HERE            ;And go back until we're done.
FINE:   POP     WORD PTR CURSOR_X
        CALL    SET_CURSOR      ;Finish and return.
        POP     CX
        RET
COLOR   ENDP

DISPLAY PROC    NEAR            ;Puts filenames on the screen.
        MOV     DI,SOURCE       ;Was a pathname specified originally?
        MOV     D1_FLAG,1
        MOV     SI,82H
        MOV     SOURCE_PATH_END,SOURCE
        MOV     BX,80H
        CMP     BYTE PTR [BX],0 ;Not if this byte is a 0.
        JE      DSPLAY2         ;No need to check on '\'.                     
TRANS2: CMP     BYTE PTR [SI],13        ;Make this an ASCIIZ string.
        JE      PUT0            
        MOVSB                           ;Transfer byte by byte to SOURCE.
        CMP     BYTE PTR [SI-1],'\'     ;Is this the end of a pathname?
        JE      STOR                    ;Yes, mark position.
        CMP     BYTE PTR [SI-1],':'     ;Is this a ":" -- also end of pathname.
        JNE     TRANS2                  ;No, keep checking.
STOR:   MOV     SOURCE_PATH_END,DI      ;Store end of pathname here.
        
        PUSH    SI                      ;POSSIBLE end of pathname discovered.
        PUSH    DI                      ;Save the "filename" that comes after.
        LEA     DI,FILENAME
        MOV     CX,10                   ;First clear the storage area.
        MOV     AL,0                    ;With 0s.
REP     STOSB
        LEA     DI,FILENAME             ;SI is already set.
        MOV     CX,9                    ;Transfer from [SI] to [DI].
ONEBY:  CMP     BYTE PTR [SI],13        ;End of "filename"?
        JNE     MOVE                    ;No, move this byte too.
        MOV     BYTE PTR [DI],0         ;Yes, make FILENAME ASCIIZ.
        JMP     SHORT FIN0
MOVE:   MOVSB                           ;Transfer 1 byte.
        LOOP    ONEBY                   ;And keep going until "filename" done.
FIN0:   POP     DI
        POP     SI                      ;Restore SI and DI.

        JMP     TRANS2
PUT0:   MOV     BYTE PTR [DI],0         ;Put the Z in ASCIIZ.
        MOV     TEST_PATH_END,DI        ;Save this in case no filename given.

        MOV     NOFILE_FLAG,0           ;For DISPLAY, set NOFILE_FLAG to 0.
        JMP     CHKFIL
DSPLAY2:MOV     D1_FLAG,0               ;Set D1_FLAG.
        CMP     FILENAME,0              ;=0 if no filename given.
        JNE     CHKFIL
        MOV     NOFILE_FLAG,1           ;Set NOFILE_FLAG.

CHKFIL: MOV     CX,25                   ; can put other filenames at end.
        MOV     CURSOR_X,0              ;Start at beginning of screen.
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR              ;Set cursor to match.
WIPE:   PUSH    CX                      ;Wipe the screen.
        CALL    SET_CURSOR
        MOV     CX,80
        MOV     AH,9                    ;Use Service 9
        MOV     BX,7
        MOV     AL,0
        INT     10H                     ;With INT 10H.
        POP     CX
        INC     CURSOR_Y                ;Keep going on this line.
        LOOP    WIPE                    ;Loop over all 25 lines.
        MOV     CURSOR_X,6              ;Set up for prompt.
        MOV     CURSOR_Y,24
        CALL    SET_CURSOR              ;Put the general prompt on.
        MOV     AH,9
        MOV     DX,OFFSET PROMPT
        INT     21H
        MOV     CURSOR_X,0              ;Reset to beginning of the screen.
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR
        MOV     DI,TEST_PATH_END                              
        CMP     NOFILE_FLAG,1           ;If no filename given, skip first search
        JE      TSLASH
        CMP     BYTE PTR [DI-1],'\'     ;Was a filename given?
        JE      NOFILE          
        CMP     D1_FLAG,1               ;Are we doing DISPLAY or DSPLAY2?
        JE      PUTA                    ;In DISPLAY, filename all set.
        CMP     FILENAME,0              ;Did FILENAME find files first time?
        JE      PUTA
        MOV     CX,10
        MOV     SI,OFFSET FILENAME      ;Use FILENAME instead of WILCARDS.
        MOV     DI,SOURCE_PATH_END
REP     MOVSB
PUTA:   MOV     AH,4EH                  ;Search for matches to filename.
        MOV     DX,SOURCE               ;QQQ
        INT     21H                     ;Was a filename given?
        JNC     MATCH1                  ;Yes, no need for wildcards.
NOFILE: MOV     FILENAME,0              ;No given filename worked in DISPLAY.
TSLASH: CMP     TEST_PATH_END,0         ;Any pathname characters typed?
        JNE     SLASH                   ;Yes, check '\'
        MOV     SOURCE_PATH_END,SOURCE  ;No, use SOURCE to load wildcards at.
        MOV     DI,SOURCE_PATH_END      ;Set up widcards -- *.* -- at end of 
        JMP     PUTW                    ; SOURCE.
SLASH:  MOV     DI,TEST_PATH_END     
        MOV     SOURCE_PATH_END,DI
        CMP     BYTE PTR [DI-1],'\'     ;If there is no '\',
        JE      PUTW                    ; put one in.
        MOV     BYTE PTR [DI],'\'
        INC     DI   
        INC     SOURCE_PATH_END         ;INC DI and Path_End by adding '\'.
PUTW:   MOV     CX,4                    
        MOV     SI,OFFSET WILDCARDS     
REP     MOVSB                           ;Move *.* into place.
SRC:    MOV     AH,4EH                  ;Search for matches to wildcard
        MOV     DX,SOURCE
        INT     21H                     ;Look for match.
        JC      ENDER                   ;If error, leave.
MATCH1: MOV     DX,0
        MOV     AH,2
        INT     10H
        CALL    PRINT                   ;Print out filename with PRINT.
        MOV     CX,120                  ;120 files max.
LOOPER: MOV     AH,4FH                  ;Search for next match, if there is one.
        INT     21H
        JC      ENDER                   ;If none, leave.
        MOV     DISP_FLAG,0FFH          ;This is a DISPLAY, do not check for
        CALL    INC_CURSOR              ; empty screen ahead of highlight.
        MOV     DISP_FLAG,0             ;Use DISP_FLAG as signal to INC_CURSOR.
        CALL    PRINT
        MOV     DX,OFFSET SOURCE        ;Get ready for search.
        LOOP    LOOPER
ENDER:  MOV     CURSOR_X,0              ;Set cursor to top of screen when done.
        MOV     CURSOR_Y,0
        CALL    SET_CURSOR
        RET
DISPLAY ENDP

INC_CURSOR      PROC    NEAR            ;This moves the highlight to the next
        PUSH    CX                      ;filename on the screen.
        MOV     DL,CURSOR_X             ;Where are we now?
        MOV     DH,CURSOR_Y
        MOV     TEMPX,DL                ;Store in temporary locations.
        MOV     TEMPY,DH
        ADD     DL,13                   ;See if we can move to the right.
        CMP     DL,75                   ;Past edge of screen?
        JL      FIN                     ;No, go ahead.
        MOV     DL,0                    ;Yes, wrap around.
        INC     DH
FIN:    MOV     CURSOR_X,DL             ;Store new positions.
        MOV     CURSOR_Y,DH
        MOV     DX,0                    ;Return OK signal.
        CALL    SET_CURSOR              ;And set new cursor.
        CMP     DISP_FLAG,0             ;Is this a DISPLAY?
        JNE     SET                     ;Yes, don't check if we are pointing to
        MOV     SI,SOURCE_PATH_END      ; a filename.
        CALL    GET_FILE_NAME           ;Are we pointing to a filename?
        CMP     BYTE PTR DS:[SI],' '
        JA      SET                     ;Yes.
        SUB     CURSOR_X,13             ;No, move back one position.
        CMP     CURSOR_X,0
        JG      LEAV                    ;And exit.
        MOV     DL,TEMPX
        MOV     CURSOR_X,DL             ;Restore temporary (original) positions.
        MOV     DH,TEMPY
        MOV     CURSOR_Y,DH
LEAV:   CALL    SET_CURSOR              ;CURSOR_X and CURSOR_Y all set, now
        MOV     DX,0FFH                 ; actually do set cursor.
SET:    POP     CX
        RET                             ;And Return.
INC_CURSOR      ENDP
                                        ;This sets cursor location on screen.
SET_CURSOR      PROC    NEAR
        PUSH    AX                      ;Save AX.
        MOV     DL,CURSOR_X             ;Get position cursor should be at.
        MOV     DH,CURSOR_Y
        MOV     AH,2
        INT     10H                     ;Use Service 2, INT 10H, and move it 
        POP     AX                      ; there.
        RET                             ;And return.
SET_CURSOR      ENDP

PRINT   PROC    NEAR                    ;This prints out filenames.
        PUSH    CX
        MOV     DX,80H+30               ;Point to name.
        MOV     BX,DX
        MOV     CX,13
LOOPA:  CMP     BYTE PTR [BX],0         ;Is it a 0?
        JE      FOUND                   ;Yes, end of filename found.
        INC     BX
        LOOP    LOOPA
FOUND:  MOV     BYTE PTR DS:[BX+1],'$'  ;Put '$' in place.
        MOV     AH,9                    ;Use String Print.
        INT     21H
        POP     CX
        RET                             ;Return.
PRINT   ENDP
DATA:                                   ;Will store 62K of data for copies
CODE_SEG        ENDS                    ; after this point.
        END     START

                                                                                                        