/* readenv.c RHS 12/15/86 rev.
 *
 * This program demonstrates how to:

        1. Read the Environment strings from a C program.
        2. Find a specific environment variable and copy it and its string to a
            local buffer for further use.
 */

#include<stdio.h>   /* include standard C header file */

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/* This code was written utilizing the DeSmet C library functions.
 * For compatibility with some C compilers, some of the source code here may
 * have to be changed.  For immediate compatibility with Microsoft C 4.0,
 * change the word FALSE on the following line to read TRUE.
 */
#define MSC FALSE
 /* This will insure compatibility with Microsoft C 4.0.
 */

#if MSC
#include<memory.h>
#include<ctype.h>
#include<dos.h>
#define _lmove(num,soff,sseg,doff,dseg)     movedata(sseg,soff,dseg,doff,num)
#define _pcb _psp
#endif

char *getvar();     /* declare functions returning pointers to characters */
extern unsigned _pcb;   /* declare external variable that holds PSP value */

main()              /* Our program begins here. */
{
    /* If the Environment variable passed to getvar() is found, this pointer
     * will receive from getvar() the address of a buffer where the entire
     * string will be placed.  If the variable is NOT found, the pointer will
     * be set by getvar() to NULL.
     */
    char *path_string;      /* declare the local pointer */

        /* Now, call SET() a function that imitates the DOS SET command by
         * reading the Environment strings one-by-one and printing them on
         * the console.  It's code is included below.
         */
    set();                  /* print the environment strings on the console */

        /* Next, call GETVAR() to find the PATH variable.  If PATH is found,
         * the entire path string will be copied by GETVAR() to a buffer.
         * Then GETVAR() will return the address of the buffer, and place it in
         * path_string.
         */
    if(path_string = getvar("PATH"))
        /* So, if path_string is NOT NULL, it will point to the full PATH
         * variable, and we can print it on the console.  We do this by
         * calling PRINTF(), a standard library function, to print the string
         * pointed to by path_string.
         */
        printf("\n%s",path_string);

    exit(0);        /* Exit this program */
}

    /************************* SUBROUTINES: *******************/

    /*********************** Subroutine Data *****************/

#define ENVIRONMENT_OFFSET 0x2C   /* Offset address of Environ. Copy in PSP */
#define MAXIMUM_ENV_STRING 127    /* macro for max. Environ. string length */

        /* macros for controlling find_env_string() */
#define FIRST 1                   /* find first string */
#define NEXT 0                    /* find next string */

    /* Buffer in which to copy an Environment string - includes 2 extra
     * spaces for NULL-terminators at end of string or end of Environment.
     */
char env_string_buffer[MAXIMUM_ENV_STRING+2];

int env_offset = 0;             /* variable for offset into the Environment */
unsigned Environment = 0;       /* variable for Environment segment address */

    /* SET() ***************************************************/
    /* calls FIND_ENV_STRING() successively in a loop and prints each
     * environment string found, until the End of the Environment is found.
     */
set()
{
    int restart;        /* restart variable */

        /* Initialize restart to find FIRST string.
         * Call FIND_ENV_STRING() as long as it returns TRUE.
         * Set restart to find NEXT string after the first call.
         */
    for( restart = FIRST ; find_env_string(restart); restart = NEXT)

            /* Call PRINTF() to print contents of buffer */
        printf("\n%s",env_string_buffer);
}

    /* GETVAR() ************************************************/
    /* Calls FIND_ENV_STRING() repeatedly until an Environment string
     * with "name" as the variable name is found, or until FIND_ENV_STRING()
     * returns FALSE, signaling that the end of the Environment was reached.
     * If the string with the right variable name is found, GETVAR() returns
     * a pointer to the Environment string buffer, otherwise it returns a

     * NULL.
     */
char *getvar(name)
char *name;
{
    int len;                        /* variable to hold length of name */
    int restart;                    /* variable to hold search control */

                /* Call standard library function STRLEN() to get the
                 * length of name and place it in len.
                 */
    len = strlen(name);

                /* Call function UPPER() to force name to upper case, since
                 * DOS forces all Environment variable names to upper case.
                 */
    upper(name);

        /* Main search loop:
         * Set restart for search for 1st environment string.
         * Loop while FIND_ENV_STRING() returns TRUE.
         * Reset restart for search for further environment strings.
         */
    for( restart = FIRST ; find_env_string(restart); restart = NEXT)

        /* Try to match the variable name with the 1st characters in the
         * Environment string found.  Make sure that the 1st character past
         * the end of the name in the string is a '=' so we really have the
         * whole string.  This way we don't confuse PATH, for instance, with
         * some other string like PATH1.
         */
    if(!strncmp(name,env_string_buffer,len) && env_string_buffer[len] == '=')

                /* if a match, return the address of the buffer */
            return env_string_buffer;

        /* Otherwise, we broke out of the loop which means we didn't find the
         * string.  So return a NULL.
         */
    return (char *)NULL;
}

    /* FIND_ENV_STRING() ****************************************/
    /* Finds the Environment strings, and copies the 1st one into
     * env_string_buffer, as long as restart is equal to FIRST.  If
     * NOT, finds the next sucessive string and copies IT into the buffer.
     * Returns TRUE if a string is found, or FALSE if end of Environment is
     * found.
     */

find_env_string(restart)
int restart;

{
    int buffer_offset;        /* variable for offset into env_string_buffer */
    unsigned _showds();

        /* If the Environment address has NOT already been obtained, */
    if(!Environment)

 /* Get the Segment address of the current DOS Environment copy into the
  * variable Environment.  _SHOWCS() and _SHOWDS() are DeSmet C functions
  * that return the current Code and Data segment register values respectively.
  * _LMOVE() is a DeSmet C function that moves a variable number of bytes
  * from an offset in one segment to an offset in other segment.  Here we
  * move 2 bytes from offset 2Ch in the PSP (which is at Code Segment-0x10
  * in C), to the address of "Environment" in the current Data Segment.
  */
        _lmove( 2, ENVIRONMENT_OFFSET, _pcb,  &Environment, _showds());

        /* If we want to start with the 1st string, reset env_offset to Zero.
         */
    if(restart)
        env_offset = 0;

            /* Initialize Buffer offset to zero.
             * Loop continuously until the end an Environment string is found.
             * Increment the Environment Offset by 1 at the end of every loop.
             */
    for( buffer_offset = 0; TRUE ; env_offset++ ){

            /* Copy 2 bytes from the environment offset in the Environment
             * segment, to the buffer_offset in the Environment string buffer.
             */
        _lmove( 2, env_offset, Environment,
			env_string_buffer[buffer_offset], _showds());

            /* If a Non-zero character was found and placed in the current
             * offset in the buffer, loop back for another one.
             */
        if(env_string_buffer[buffer_offset]){
            buffer_offset++;
            continue;
        }

            /* We must have found a Zero to get this far without looping back.
             * If buffer_offset is Zero, the 1st character found was a Zero and
             * we are at the end of the Environment strings - return FALSE.
             */
        if( !buffer_offset)
            return FALSE;

            /* Otherwise, We have found the end of a string, so increment the
             * Environment offset by one to point to the next one for next time.
             * Then return TRUE (TRUE that we did NOT find the end of the
             * Environment strings.
             */
        env_offset++;
        return TRUE;
    }
}

    /* UPPER() *******************************************/
    /* Uppercases the string passed by calling the standard library function,
     * TOUPPER(), which returns the uppercase version of a single character.
     */
upper(string)
char *string;
{
        /* A simple "FOR" loop in C:
         * Nothing is initialized.
         * Loop as long as the character pointed to by string is not a Zero
         * (a NULL-terminator).
         * Then increment the pointer to point to the next character.
         */
    for( ; *string; string++)
            /* For each character, call TOUPPER() to return the uppercase
             * version of the character, and set the character to it.
             */
        *string = toupper(*string);

}

#if MSC
    /* _SHOWDS() ********************************************/
    /* Returns DS register value.
     */

unsigned _showds()
{
    struct SREGS segregs;

    segread(&segregs);
    return segregs.ds;
}
#endif

     /*********************** End of Readenv.c ****************/
                                                                                                                                                                                                                                                                                                                   