;
; PC MagNet Utilities Database Down Load Script,
; written for/with Procomm Plus v1.1b,
; by Rick Ayre 6.2.90.
;

ASSIGN S1 "EMPTY"      ; create five string variables,
ASSIGN S2 "EMPTY"      ; and place the string EMPTY
ASSIGN S3 "EMPTY"      ; in each
ASSIGN S4 "EMPTY"
ASSIGN S5 "EMPTY"

GET_NAMES:        ; routine to create a menu that asks the user
   CLEAR          ; for the names of the files to down load
   BOX 2 20 9 68 79                                   ; draw box
   ATSAY 3 28 15 "PC MagNet Utilities Database"       ; place text in box
;  ATSAY 5 28 15 "Down Load Script"
   ATSAY 7 28 15 "File to Down Load: "
   ATSAY 7 47 15 "____________"
   ATGET 7 47 15 12 S0                                ; get file name
   SWITCH S0
      CASE "_NULL"               ; make sure there IS a file name
         GOTO What_Now
      ENDCASE
      DEFAULT
         ISFILE S0               ; check to see if file already exists
         IF SUCCESS
            CLEAR
            MESSAGE "File Exists - Get Anyway? (Y/N)"
              GET S7
              SWITCH S7
                 CASE "N"
                    GOTO Main_Menu
                 ENDCASE
                 DEFAULT
                    GOTO File_Names
                 ENDCASE
              ENDSWITCH
         ELSE
            GOTO File_Names
      ENDCASE
   ENDSWITCH

FILE_NAMES:       ; routine to grab the file names and assign them to S1-S5
        FIND S1 "EMPTY"          ; check to see if S1 is empty
        IF FOUND                 ; if it is
                ASSIGN S1 S0     ; put file name in it
        GOTO GET_ANOTHER
        ENDIF
        FIND S2 "EMPTY"          ; if S1 already has a file name
        IF FOUND                 ; check S2
                ASSIGN S2 S0     ; etc.
        GOTO GET_ANOTHER
        ENDIF
        FIND S3 "EMPTY"
        IF FOUND
                ASSIGN S3 S0
        GOTO GET_ANOTHER
        ENDIF
        FIND S4 "EMPTY"
        IF FOUND
                ASSIGN S4 S0
        GOTO GET_ANOTHER
        ENDIF
        FIND S5 "EMPTY"
        IF FOUND
                ASSIGN S5 S0
        ELSE                     ; if all variable have file names
        CLEAR                    ; clear the screen
        MESSAGE "Only Five Files At a Time!"   ; leave this
        PAUSE 5                                ; message
        GOTO LOG_ON                            ; then jump to the logon routine
        ENDIF

GET_ANOTHER:      ; routine that asks if there are more files to down load
        CLEAR
        BOX 2 20 6 60 79
        ATSAY 4 24 15 "Down Load Another (Y/N): "
        ATSAY 4 50 15 "_"
        ATGET 4 50 15 1 S8
                SWITCH S8
                CASE "Y"
                        GOTO GET_NAMES
                ENDCASE
                CASE "N"
                        GOTO LOG_ON
                ENDCASE
                ENDSWITCH

WHAT_NOW:         ; routine to recover from off line errors
        CLEAR
        BOX 2 20 6 60 79
        ATSAY 4 24 15 "End This Script? (Y/N): "
        ATSAY 4 52 15 "_"
        ATGET 4 52 15 1 S9
                SWITCH S9
                CASE "Y"
                        GOTO GET_OFF
                ENDCASE
                CASE "N"
                        GOTO GET_NAMES
                ENDCASE
                ENDSWITCH

LOG_ON:           ; routine to log on to CompuServe
        FIND S1 "EMPTY"
        IF FOUND
	     GOTO Get_Out
	ENDIF
        CLEAR
        IF NOT LINKED
           DIAL "1"   ;the number in your Dialing Directory goes here
        ENDIF
        PAUSE 1
        TRANSMIT "^M"
        IF CONNECTED
           WAITFOR "ost Name:  " 3 ;*
           IF WAITFOR
              PAUSE 1
              TRANSMIT "cis^M"
           ENDIF
        ELSE
           TRANSMIT "^M"
        ENDIF
        WAITFOR "User ID: "
        PAUSE 1
        TRANSMIT "#####,###^M"       ; your UserID goes here in place of "#"s
        WAITFOR "Password: "
        PAUSE 1
        TRANSMIT "*******.*****^M"   ; your Password here in place of "*"s
        CLEAR
        WAITFOR "New"
        PAUSE 4

GET_FILE:         ; routine to navigate the PC MagNet Utilites Database
        ASSIGN S0 S1
        TRANSMIT "GO UTILIT^M"
        WAITFOR "!"
        PAUSE 1
        TRANSMIT "4^M"
        WAITFOR "ample, DR.COM): "
        PAUSE 1
        TRANSMIT S0              ; down load file
        TRANSMIT "^M"
        WAITFOR "his file? (Y/N):" 15   ; this conditional WAITFOR
        IF WAITFOR                      ; traps online errors
                TRANSMIT "Y^M"
        ELSE
                GOTO ERROR
        ENDIF
        WAITFOR " begin transfer!"
        PAUSE 1
        TRANSMIT "^M"
        WAITFOR "!"
        PAUSE 1
        TRANSMIT "5^M"
        WAITFOR "Downloading..."  ;**** This line, and the GETFILE line
        PAUSE 1
        GETFILE CISB  ;**** must be deleted if you set ENQ to CIS B in Setup
        WAITFOR "!"
        PAUSE 1

GIVE_FILE_NAME:           ; routine to pass file names to down load routine
   FIND S5 "EMPTY"               ; check to see if S5 is empty
   IF NOT FOUND                  ; if it isn't
      ASSIGN S1 S5               ; pass that file name to S1 to be down loaded
      ASSIGN S5 "EMPTY"          ; then make it empty
      GOTO GET_FILE
   ENDIF
   FIND S4 "EMPTY"               ; if S5 is already empty
   IF NOT FOUND                  ; check out S4
      ASSIGN S1 S4               ; etc.
      ASSIGN S4 "EMPTY"
      GOTO GET_FILE
   ENDIF
   FIND S3 "EMPTY"
   IF NOT FOUND
      ASSIGN S1 S3
      ASSIGN S3 "EMPTY"
      GOTO GET_FILE
   ENDIF
   FIND S2 "EMPTY"
   IF NOT FOUND
      ASSIGN S1 S2
      ASSIGN S2 "EMPTY"
      GOTO GET_FILE
   ELSE
      GOTO GET_OFF
   ENDIF

ERROR:            ; routine to correct from line errors
   CLEAR
   MESSAGE "Can't Find That File"
   MESSAGE "Continue With Next? (Y/N)"
   GET S6
   SWITCH S6
      CASE "Y"
         GOTO LOOP_2
      ENDCASE
      CASE "N"
         GOTO GET_OFF
      ENDCASE
   ENDSWITCH

GET_OFF:          ; routine to log off
   TRANSMIT "OFF^M"
   PAUSE 2
   TRANSMIT "OFF^M" ; I know it seems redundent, BUT
   PAUSE 1          ; this is one of those things that MUST be done,
   HANGUP           ; for the few cases when one OFF doesn't take

GET_OUT:          ; routine to end script
   CLEAR
   MESSAGE "Thanks for visiting PC MagNet!"
   EXIT
