/* Example of a .EXE modifying program. Works on itself */ 
/* by incrementing counter every time it's executed.    */

#include <stdio.h>
#include <string.h>

typedef struct { char marker[7]; int counter; } config_data;
config_data cdat = { "%(@#@)", 0 };

long find_data(FILE *f, char *marker)
/* Returns the location of the data, or returns -1 */
{
  long nf = 0;
  int ns = 0;

  while(!feof(f)) {
     nf++;
     /* if characters don't match, reset search string */
     if (marker[ns++] != fgetc(f)) ns = 0;
     /* if at end, we have match, so return location */
     if (marker[ns] == 0) return nf-strlen(marker);
  }
  return -1L;
}

int main(int argc, char *argv[])
{
  FILE *f;
  long data_locn;

  f = fopen(argv[0], "r+b"); /* open up self for update */  
  data_locn = find_data(f, cdat.marker);
  if (data_locn == -1)
     fprintf(stderr, "Oops! Can't find the data!\n");
  else {
     fseek(f, data_locn, 0); /* read data */
     fread(&cdat, sizeof(cdat), 1, f);
     cdat.counter++;         /* increment counter */
     printf("Program has executed %d times\n", cdat.counter);    
     fseek(f, data_locn, 0); /* store data */
     fwrite(&cdat, sizeof(cdat), 1, f);
  }
  fclose(f);
  return 0;
}
