/*
These variables define the stack segment and offset
to be used by the TSR.
*/
unsigned my_ss, my_sp;

/*
Minimum number of paragraphs required for TSR's
stack.
*/
#define MIN_STACK  0x40

/*
Install a TSR.
Keep enough memory for the dynamic heap and stack.
The 'heap' and 'stack' parameters are the number of
paragraphs required by the heap and stack
respectively.
*/
void install_tsr(unsigned heap, unsigned stack)
{
unsigned PSP, EODATA, keeplen;

/*
Get beginning and end of program memory.
*/
PSP = GetPSP();
EODATA = EndPrg();

/*
Make sure we have enough stack space.
*/
stack = max(MIN_STACK, stack);

/*
Amount of memory required is (program size + heap +
stack).
*/
keeplen = EODATA - PSP + heap + stack;

/*
Stack comes after data segment and heap and grows
down in memory.
*/
my_ss = EODATA;
my_sp = (heap + stack) * 16;

/*
keep(status, size) is a Turbo C function that keeps
'size' paragraphs in memory and exits to DOS with
status 'status'.  It uses DOS function 0x31.
*/
keep(0, keeplen);
}

/*
Initialize TSR stack, run the TSR, restore
interrupted program's stack, and return control to
interrupted program.
*/
void init_tsr(void)
{
/*
These must be static variables because local
variables are addressed from the stack, which we
will be changing.
*/
static unsigned old_ss, old_sp;

/*
Save old stack frame.  _SS and _SP are Turbo C
pseudo-variables that directly address the SS and SP
registers.
*/
old_ss = _SS;
old_sp = _SP;

/*
Set up the TSR stack.  disable() and enable() are
Turbo C pseudo-functions that disable and enable
interrupts.  The last thing we want is for an
interrupt to occur while we're changing the stack!
*/
disable();
_SS = my_ss;
_SP = my_sp;
enable();

/*
run_tsr() is user-defined, i.e. implemented by the
programmer.
*/
run_tsr();

/*
Restore original program's stack.
*/
disable();
_SS = old_ss;
_SP = old_sp;
enable();
}
