'     TEXTIFY.BAS
'     by Robert Stearns
'     For Turbo Basic/PowerBASIC
'
'     This program will take any file and create a BASIC program
'     which will recreate the file, but which contains no characters
'     that could cause any communications link a problem. The only
'     characters in the file are those from the 95 character graphic
'     subset of the ASCII set, and many of the more obscure
'     characters from that group have been eliminated as well. Any
'     file created with program should pass through almost any
'     communications link unscathed. I even made sure the maximum
'     line length was less than 72.
'
defint a-z                   ' all integers makes everything faster
dim table$(63)               ' the character conversion table
chunksize=36                 ' handle the file in pieces this size
a$=command$                  ' get the name of the file to convert
'
'     if the file name is not present in the command line, get it
'     from the user interactively.
'
if a$="" then
     input "Type the name of the file to process";a$
end if
open a$ for binary as 1
'
'     the output file name will be the same as the input file name,
'     including path, but with the extension BAS.
'
i=instr(a$,".")
if i=0 then b$=a$ else b$=left$(a$,i-1)
b$=b$+".BAS"
open b$ for output as 2
'
'     move the selected characters to the array to simplify and
'     even speed up their access.
'
read tb$,tbx$
tb$=tb$+tbx$
for i=0 to 63
     table$(i)=mid$(tb$,i+1,1)
next i
'
'     read the conversion program from the data statements and
'     write it as the prefix to the converted data.
'
do
     read bline$
     print #2,bline$
loop until bline$=" 9999 '"
'
'    write the first data statement containing the file length and
'    file name to the converted file.
'
filelen!=lof(1)
print #2,using "##### DATA ";10000;
print #2,a$,",",filelen!
print filelen!;" bytes to do"' Tell the user how much there is to do
lineno=10001                 ' The line number in the output program
filepos!=1                   ' Current position in the input file
lim!=1000                    ' When to tell how much we've done
'
'     This is the main code of the program. It reads chunks of the
'     input file, converts each group of three bytes to four
'     characters in the output file, and writes the characters to
'     the output file in the form of data statements. As the input
'     is processed, a checksum is formed for each chunk and the
'     checksum is written to the output file to be checked by the
'     program which will reconstruct the file.
'
while(filepos!<=filelen!)
     seek #1,filepos!-1
     if filepos!+chunksize-1<=filelen! then
          get$ #1,chunksize,t$
     else
          get$ #1,filelen!-filepos!+1,t$
	  i=len(t$) mod 3          ' for the rest of the code to
	  if i=0 then i=3          ' work properly, there must be a
	  t$=t$+left$("   ",3-i)   ' multiple of 3 chars in t$
     end if
     print #2,using "##### DATA ";lineno;
     lineno=lineno+1
     checksum=0
     for i=1 to len(t$) step 3
          j1=asc(mid$(t$,i  ,1))          'aaaaaaaabbbbbbbbcccccccc
          j2=asc(mid$(t$,i+1,1))          '111111222222333333444444
          j3=asc(mid$(t$,i+2,1))          ' as the above bit map
          c1=                    j1 \ 4   ' shows, we will convert
          c2=((j1 and 3)  * 16 )+j2 \ 16  ' 24 bits of three data
	  c3=((j2 and 15) * 4  )+j3 \ 64  ' bytes to four numbers
          c4= (j3 and 63)                 ' between 0 and 63.
          print #2,table$(c1);            ' Next, we print them as
          print #2,table$(c2);		  ' characters which can be
          print #2,table$(c3);		  ' converted back to the
          print #2,table$(c4);		  ' corresponding numbers.
          checksum = checksum+j1+j2+j3    ' always <= chunksize*255
     next i
     print #2,",";checksum
     filepos!=filepos!+chunksize
     if filepos!>lim! then
          print filepos!;" bytes done"
          lim!=lim!+1000
     end if
wend
'
'     put on the final data statement indicating the end of the
'     file, close the files and tell the user we are done
'
print #2,using "##### DATA ";lineno;
print #2,chr$(34);chr$(34);",0"
close #1
close #2
print "Files closed, job complete"
stop
'
'     The characters to which the file is converted
'
data ABCDEFGHIJKLMNOPQRSTUVWXYZ
data abcdefghijklmnopqrstuvwxyz0123456789@$
'
'    The file reconstruction program less the data statements
'    which describe the file to be built. This program does the
'    inverse transform of the program above. It processes each
'    group of four characters into 6 bit integers, then concatenates
'    consecutive groups of 8 bits into output characters. These
'    output characters are then written to the output file until
'    the original file size is reached.
'
data "   10 DEFINT A-Z"
data "   15 READ TB$,TBX$,FC$,JS$,JE$"
data "   16 TB$=TB$+TBX$"
data "   20 READ A$"
data "   30 OPEN A$ FOR OUTPUT AS #1"
data "   40 READ FS!"
data "   45 PRINT JS$;CHR$(32);A$"
data "   50 READ LN$,CS"
data "   55 L=10001"
data "   60 WHILE(LEN(LN$)<>0)"
data "   65      CC=0"
data "   70      FOR I=1 TO LEN(LN$) STEP 4"
data "   80           D1=INSTR(TB$,MID$(LN$,I  ,1))-1"
data "   90           D2=INSTR(TB$,MID$(LN$,I+1,1))-1"
data "  100           D3=INSTR(TB$,MID$(LN$,I+2,1))-1"
data "  110           D4=INSTR(TB$,MID$(LN$,I+3,1))-1"
data "  120           C1=((D1* 4) + (D2 \ 16)) AND 255"
data "  130           C2=((D2*16) + (D3 \  4)) AND 255"
data "  140           C3=((D3*64) +  D4      ) AND 255"
data "  145           CC=CC+C1+C2+C3"
data "  150           PRINT #1,CHR$(C1);"
data "  160           X!=X!+1"
data "  170           IF X!<FS! THEN PRINT #1,CHR$(C2); : X!=X!+1"
data "  180           IF X!<FS! THEN PRINT #1,CHR$(C3); : X!=X!+1"
data "  190      NEXT I"
data "  195      IF CC<>CS THEN PRINT FC$;L"
data "  200      READ LN$,CS"
data "  205      L=L+1"
data "  210 WEND"
data "  220 CLOSE #1"
data "  225 PRINT A$;CHR$(32);JE$"
data "  230 STOP"
data " 1000 DATA ABCDEFGHIJKLMNOPQRSTUVWXYZ"
data " 1005 DATA abcdefghijklmnopqrstuvwxyz0123456789@$"
data " 1010 DATA FILE CORRUPTED AT"
data " 1020 DATA CREATING FILE"
data " 1030 DATA HAS BEEN CREATED"
data " 9999 '"