UNIT ValX;

{  Author: George W. Seaton  FOR: Turbo Pascal 5.5 }

INTERFACE

PROCEDURE ValI(S: STRING; VAR V: Integer; VAR C: Integer);
PROCEDURE ValB(S: STRING; VAR V: Byte; VAR C: Integer);
PROCEDURE ValW(S: STRING; VAR V: Word; VAR C: Integer);

IMPLEMENTATION

VAR
  Lint: LongInt;             {Used to range-check values}

PROCEDURE ValI(S: STRING; VAR V: Integer; VAR C: Integer);

CONST
  MaxIV: LongInt =  32767;
  MinIV: LongInt = -32768;

BEGIN
  Val(S,Lint,C);
  IF ((C = 0) AND (Lint >= MinIV) AND (Lint <= MaxIV)) THEN
    V := Lint
  ELSE C := -1;
END;

PROCEDURE ValB(S: STRING; VAR V: Byte; VAR C: Integer);

CONST
  MaxBV: LongInt =    255;
  MinBV: LongInt =      0;

BEGIN
  Val(S,Lint,C);
  IF ((C = 0) AND (Lint >= MinBV) AND (Lint <= MaxBV)) THEN
    V := Lint
  ELSE C := -1;
END;

PROCEDURE ValW(S: STRING; VAR V: Word; VAR C: Integer);

CONST
  MaxWV: LongInt =  65535;
  MinWV: LongInt =      0;

BEGIN
  Val(S,Lint,C);
  IF ((C = 0) AND (Lint >= MinWV) AND (Lint <= MaxWV)) THEN
    V := Lint
  ELSE C := -1;
END;

END.
