#ifndef __TYPES_H
#define __TYPES_H

enum datatype{EMPTY,
				  INT,LONG,FLOAT,DOUBLE,LDOUBLE,
				  STRING,
				  DERIVED};
class value{
  public:
	char* namptr;
	value();	value(char* namestr);			//constructor
	virtual ~value();								//destructor
	//return characteristics
	virtual const char* name(){return namptr;}
	virtual int valid();
	virtual datatype type(); virtual const char* typename();
	//return value in different forms
	virtual int asint();
	virtual long aslong();
	virtual float asfloat();
	virtual double asdouble();
	virtual long double asldouble();
	virtual const char* asstring();};

class ival:public value{
 protected:
	int data;	
 public:
	ival(char* namestr, int val);
	datatype type(); const char* typename();
	int asint();
	long aslong();
	float asfloat();
	double asdouble();
	long double asldouble();
	const char* asstring();};

class lval:public value{
 protected:
	long data;	
 public:
	lval(char* namestr, long val);
	datatype type(); const char* typename();
	int asint();
	long aslong();
	float asfloat();
	double asdouble();
	long double asldouble();
	const char* asstring();};

class fval:public value{
 protected:
	float data;	
 public:
	fval(char* namestr, float val);
	datatype type(); const char* typename();
	int asint();
	long aslong();
	float asfloat();
	double asdouble();
	long double asldouble();
	const char* asstring();};

class dval:public value{
 protected:
	double data;	
 public:
	dval(char* namestr, double val);
	datatype type(); const char* typename();
	int asint();
	long aslong();
	float asfloat();
	double asdouble();
	long double asldouble();
	const char* asstring();};

class ldval:public value{
 protected:
	long double data;	
 public:
	ldval(char* namestr, long double val);
	datatype type(); const char* typename();
	int asint();
	long aslong();
	float asfloat();
	double asdouble();
	long double asldouble();
	const char* asstring();};

class sval:public value{
 protected:
	char* data;
 public:
	sval(char* namestr, char* val);
	~sval(); //supplemental destructor
	datatype type(); const char* typename();
	int asint();
	long aslong();
	float asfloat();
	double asdouble();
	long double asldouble();
	const char* asstring();};

#endif
