/* HEAPSTAT.C Heap status routines for Microsoft C */

#include <stdlib.h>
#include <malloc.h>
#include "heapstat.h"
#ifdef __WATCOMC__
               /* there isn't a far version in 386 mode */
#define _fheapwalk _heapwalk
#define _fheapchk  _heapchk
               /* also typedef difference in malloc.h */
int (*walkf[2])(struct _heapinfo *phi) = { _nheapwalk, _fheapwalk };
/* Watcom uses different return values for heap management */
static char *heap_status[] = { "ok", "empty", "bad-begin",
    "bad-node", "end", "bad-ptr" };
#else /* Microsoft C heap stuff */
int (*walkf[2])(_HEAPINFO *phi) =   { _nheapwalk, _fheapwalk };
static char *heap_status[] = { "?free?", "empty", "ok", "bad-begin",
    "bad-node", "end", "bad-ptr" };
#endif

int (*statf[2])(void) =             { _nheapchk, _fheapchk } ;

void heap_stats(HEAP h, HEAP_STATS *hs)
{
    struct _heapinfo hi;

    hs->heap = h;
    hs->used = hs->free = hs->blks = 0;
    hi._pentry = 0;
    /* walk the heap, calling walk function for each block */
    while ((*walkf[h])(&hi) == _HEAPOK)
    {
        switch (hi._useflag)
        {
            case _USEDENTRY: hs->used += hi._size; break;
            case _FREEENTRY: hs->free += hi._size; break;
        }
        hs->blks++;
    }
    hs->status = (*statf[h])();

#ifdef __WATCOMC__    /* Watcom uses positive numbers */
  hs->status_str = heap_status[ hs->status];
#else
  hs->status_str = heap_status[- hs->status];
#endif
}

void print_heap_stats(HEAP_STATS *hs)
{
  printf("%s heap used=%lu free=%lu blks=%lu status=%s\n",
        (hs->heap == NEARHEAP) ? "near" : "far",
        hs->used,
        hs->free,
        hs->blks,
        hs->status_str);
}
