/* KEYBUFF.C -- Keyboard Buffer Stuffer Demo
   For "PC Techniques" by Shawn D. Wolf      */

/* REMEMBER:
   This source uses the 80x86-specific (non-ANSI) "far"
   keyword (supported by both Turbo C/C++ and Microsoft C
   in their "native" modes).  DO NOT compile the source in
   an "ANSI source" mode.

   ALSO: Do not run the .EXE from the Borland IDE. (It will
   "type" into the IDE windows!)  Shell out to DOS and run
   it from the DOS prompt. */

/* ------- function prototypes ------- */
void clear_key_buff(void);
int key_buff_space(void);
int put_char_in_buff(unsigned char bchar,int extend);
int put_string_in_buff(char *str_ptr);

#include <dos.h>

/* ------- global pointers ------- */
/* keyboard buffer head: */
static int far *bufferhead = (int far *) 0x41A;
/* keyboard buffer tail: */
static int far *buffertail = (int far *) 0x41C;
/* keyboard buffer: */
static char far *keybuffer = (char far *) 0x41E;

/* ------- start of code ------- */
/* This listing for Turbo C. For Microsoft C, change disable() to
   _disable() and enable() to _enable(). */

main ()
   {
   clear_key_buff();
   put_string_in_buff("DIR\x0D");

   /* Now let's put an 'F3' to repeat last command. */

   put_char_in_buff('\x3D',1);    /* Put 'F3' into buffer. */
   put_char_in_buff('\x0D',0);    /* Put 'RETURN' into buffer. */

   return 0;
   }


void clear_key_buff(void)
   /* clears the keyboard buffer by setting the tail = head */
   {
   disable();     /* turn off the normal keyboard interrupt */
   *buffertail = *bufferhead;
   enable();               /* restore the normal interrupts */
   }


int key_buff_space(void)
   /* Returns the number of free keypress spaces in the buffer.
      (not bytes.) Returns 15 if buffer is empty, 0 if full. */
   {
   return (15 - ((*buffertail - *bufferhead) / 2)) % 16;
   }


int put_char_in_buff(unsigned char bchar,int extend)
   /* Places passed character into keyboard buffer. If extend is
      true, treats keypress as extended and places it into
      second byte.  Otherwise, places it into first byte. */
   {
   unsigned char first_byte,second_byte;

   if (!key_buff_space())      /* Is the keyboard buffer full? */
      return 0;                /* If so, return error. */

   if (extend)                 /* Is this an extended keypress? */
      {                        /* Yes, it is extended. */
      first_byte = 0;          /* Zero goes in first byte. */
      second_byte = bchar;     /* Passed char goes into second. */
      }
   else                              /* No, it is not extended. */
      {
      first_byte = bchar;  /* Passed char goes into first byte. */
      second_byte = '/';   /* Dummy scan code goes into second. */
      }

   /* Place first byte: */
   *(keybuffer + (*buffertail - 0x1E)) = first_byte;
   /* Increment the tail - no need to check for wrap: */
   ++(*buffertail);

   /* Place 2nd byte: */
   *(keybuffer + (*buffertail - 0x1E)) = second_byte;
   if (++(*buffertail) > 0x3D) /* Increment tail - check for wrap. */
      *buffertail = 0x1E;      /* If wrap, set tail to
                                  lowest buffer memory. */

   return 1;
   }


int put_string_in_buff(char *string_ptr)
   /* Takes passed string and places it into keyboard buffer.
      Returns true on success, false on failure. */
   {
   int rval;

   rval = 1;
   disable();                  /* Don't interrupt this string. */
   while (*string_ptr)         /* Loop thru each char in string.  */
      /* Put char into buffer: */
      if (!put_char_in_buff(*string_ptr++,0))
         {             /* We're assuming it's a normal keypress.  */
         rval = 0;     /* If placement not successful, exit loop. */
         break;
         }

   enable();                         /* Restore interrupts. */

   return rval;                      /* Return success status. */
   }
