ECHO OFF
echo Build Procedure for sample program LIST.C
echo ==========================================

if .%1 == ./h goto help
if .%1 == .   goto help
if .%1 == ./86 goto realmode
if .%1 == ./286 goto pm286
if .%1 == ./386 goto pm386
goto badopt

:realmode:
echo Making real mode version of LIST.C 
echo ==========================================
cl -AL list.c heapstat.c
if errorlevel 1 goto err
goto end

:pm286
echo Making Phar Lap 286-DOS version of LIST.C 
echo ==========================================
run286 cl -AL -Lp list.c heapstat.c
if errorlevel 1 goto err
goto end

:pm386
echo Making Phar Lap 386-DOS version of LIST.C 
echo ==========================================
wcl386  list.c heapstat.c  /d2  /k20000
if errorlevel 1 goto err
goto end

:err
ECHO An error occured during build
goto end

:badopt
ECHO Error, "%1" is not a valid argument

:help
ECHO .
ECHO HELP
ECHO  Valid options are
ECHO .
ECHO  /86    standard DOS real mode, using Microsoft C 6.0A   
ECHO  /286   286 DOS protected mode, using Microsoft C 6.0A
ECHO  /386   386 DOS protected mode, using Watcom C 8.0

:end 
