(* STRTEST.PAS -- efficient string allocation in Turbo Pascal *)
Program StringTest;
Type
    NameString	= String[80];
    StringPtr 	= ^String;

(* FreeString -- Free the memory allocated to a dynamic string *)
Procedure FreeString (Var s : StringPtr);
Begin
    If s <> Nil Then Begin
	FreeMem (s, Length (s^) + 1);
	s := Nil;
    End;
End;

(* AssignString -- Dynamically allocate string space *)
Procedure AssignString (Var s : StringPtr; t : String);
Begin
    FreeString (s);
    GetMem (s, Length (t) + 1);
    s^ := t;
End;

(* Global variables for main program *)
Type
    NameArray	= Array [1..10] of StringPtr;
Var
    Names	: NameArray;
    x		: integer;
    TempName	: NameString;

Begin (* Main program *)
    (* Initialize the string pointers to Nil *)
    For x := 1 to 10 do
	Names[x] := Nil;

    WriteLn ('Available memory = ', MemAvail);

    (* Read the strings and store them in a buffer *)
    For x := 1 to 10 do Begin
	Write ('Enter Name: ');
	ReadLn (TempName);
	AssignString (Names[x], TempName);
    End;

    (* Test assignment to existing string *)
    AssignString (Names[5], 'This is a test');

    (* Display the strings from the buffer and *)
    (* free each string after it's displayed *)
    For x := 1 to 10 Do Begin
	WriteLn (Names[x]^);
	FreeString (Names[x]);
    End;

    WriteLn ('Available memory = ', MemAvail);
End.
