; smemcpy.asm: Smart memory copy routine
; Runs in protected mode; avoids protection faults by validating
; the pointers given before attempting the copy.
; Copyright (C) 1991 by Nicholas Wilt.	All rights reserved.

.MODEL	LARGE

.286P

.CODE

; void smemcpy(void *dest, void *src, unsigned numbytes);

	PUBLIC	_smemcpy

_smemcpy   PROC
	push	bp		; Establish stack frame
	mov	bp,sp		;
	push	ds		; Save registers
	push	si		;
	push	di		;

	mov	ax,[bp+8]	; Get selector of dest pointer
	verw	ax		; Can we write to it?
	jnz	DoneCopy	; Jump if no
	mov	es,ax		; Otherwise put selector in ES
	mov	si,[bp+6]	; Get offset portion of pointer
	mov	ax,[bp+12]	; Get selector of src pointer
	verr	ax		; Can we read from it?
	jnz	DoneCopy	; Jump if no
	mov	ds,ax		; Other
	mov	di,[bp+10]	; Get offset portion of pointer
	mov	cx,[bp+14]	; Get count
	rep	movsb		; Do the copy (slowly, I know)
DoneCopy:
	pop	di		; Restore registers
	pop	si		;
	pop	ds		;
	pop	bp		; Restore stack frame
	ret			; Return
_smemcpy   ENDP

	END
