/*--------------------------------------------------------*/
/* File: LISTING2.C   By: Marv Luse, Autumn Hill Software */
/*                                                        */
/* Desc: Program to illustrate the results of dithering.  */
/*       An 8-level filled circular region is dithered    */
/*       and rendered as a bi-level image.  Result is     */
/*       shown on-screen using Borland C++ and BGI.       */
/*       (Use Options-Compiler-Source = "Borland C++")    */
/*--------------------------------------------------------*/
#include "stdlib.h"
#include "stdio.h"
#include "conio.h"
#include "dos.h"
#include "graphics.h"
/*--------------------------------------------------------*/
/* Dithering types and data                               */
/*--------------------------------------------------------*/
typedef unsigned char DITHER_CELL[4];
DITHER_CELL log_4x4[] = {
  { 0x00, 0x00, 0x00, 0x00, }, { 0x00, 0x04, 0x00, 0x00, },
  { 0x00, 0x04, 0x04, 0x00, }, { 0x00, 0x04, 0x06, 0x00, },
  { 0x04, 0x06, 0x06, 0x00, }, { 0x04, 0x06, 0x0E, 0x02, },
  { 0x0C, 0x07, 0x0E, 0x0B, }, { 0x0F, 0x0F, 0x0F, 0x0F, },};
/*--------------------------------------------------------*/
/* Variables to create 8-level pixel array                */
/*--------------------------------------------------------*/
#define pxWIDTH     175
#define pxHEIGHT    175
#define pxRADIUS     80
char pxl_array[pxHEIGHT][pxWIDTH];
/*--------------------------------------------------------*/
/*  compute integer square root                           */
/*--------------------------------------------------------*/
int isqrt( int n ) {
    long xnew, xold, y, d;
    y    = n; /* initialize */
    xnew = y;
    xold = y / 2;
    d    = xold;
/* compute integer part of square root */
    while( (d > 1) && (xold > 0) ) {
         xnew = xold;  xnew += y/xold;  xnew /= 2;
         d = xold - xnew;
         xold = xnew;
    }
/* if desired, round to nearest integer */
    xold = xnew + 1;
    if( (n - xnew*xnew) > (xold*xold - n) )
        xnew++;
    return( (int) xnew );
}
/*--------------------------------------------------------*/
/* Build filled circular image                            */
/*--------------------------------------------------------*/
void create_image( void ) {
    int   i, j, xo, yo;
    int   d, dx, dy, dxy;

    xo = pxWIDTH / 2;    /* center of circle */
    yo = pxHEIGHT / 2;
/* compute pixel values for filled circle */
    for( i=0; i<pxHEIGHT; i++ ) {
       dy = i - yo;
       for( j=0; j<pxWIDTH; j++ ) {
          dx = j - xo;
          dxy = dx*dx + dy*dy;
          d  = isqrt( dxy );
          if( d <= pxRADIUS ) {
             d *= 7;
             d /= pxRADIUS;
             pxl_array[i][j] = d;
          }
          else
             pxl_array[i][j] = 0;
       }
    }
}
/*--------------------------------------------------------*/
/* Draw 8-level version of circle                         */
/*--------------------------------------------------------*/
void draw_color_image( void ) {
   int i, j;

    for( i=0; i<pxHEIGHT; i++ ) {
       for( j=0; j<pxWIDTH; j++ ) {
          putpixel( j, i, pxl_array[i][j] );
       }
    }
}
/*--------------------------------------------------------*/
/* Draw dithered version of circle                        */
/*--------------------------------------------------------*/
void draw_dithered_image( void ) {
    int           i, j, r, p;
    unsigned char mask;

    for( i=0; i<pxHEIGHT; i++ ) {
       r  = i % 4;
       mask = 0x08;
       for( j=0; j<pxWIDTH; j++ ) {
          p  = pxl_array[i][j];
          if( log_4x4[p][r] & mask )
              putpixel( pxWIDTH+j+5, i, 7 );
          if( (mask>>=1) == 0 ) mask = 0x08;
       }
    }
}
/*------------------------------------------------------------------*/
/* Get contents of specified VGA palette register...                */
/*------------------------------------------------------------------*/
int get_vga_pal_register( int reg_no ) {
     union REGS r;

     r.h.ah = 0x10;                    /* function 10h */
     r.h.al = 0x07;                    /* subfunction 07h */
     r.h.bl = (unsigned char) reg_no;  /* register number */
     int86( 0x10, &r, &r );
     return( (int) r.h.bh );
}
/*------------------------------------------------------------------*/
/* Set contents of specified VGA DAC register...                    */
/*------------------------------------------------------------------*/
void set_vga_dac_register( int reg_no, unsigned char rgb[] ) {
     union REGS r;

     r.h.ah = 0x10;      /* function 10h */
     r.h.al = 0x10;      /* subfunction 10h */
     r.x.bx = reg_no;    /* register number */
     r.h.dh = rgb[0];    /* 6-bit red component */
     r.h.ch = rgb[1];    /* 6-bit grn component */
     r.h.cl = rgb[2];    /* 6-bit blu component */
     int86( 0x10, &r, &r );
}
/*--------------------------------------------------------*/
/* Main to illustrate dithering visually                  */
/*--------------------------------------------------------*/
void main( void ) {
     int  i, dac, gDrvr=0, gMode;
     unsigned char rgb[3];

     printf( "building image, please wait..." );
     create_image();
     printf( "done\n" );
     initgraph( &gDrvr, &gMode, "" );
/* modify VGA palette to show 8 gray scales */
     for( i=0; i<8; i++ ) {
        dac = get_vga_pal_register( i );
        rgb[0] = rgb[1] = rgb[2] = i << 3;
        set_vga_dac_register( dac, rgb );
     }
     draw_color_image();
     draw_dithered_image();
     getch();
     closegraph();
}
