TITLE   MSDOS.ASM -- MS-DOS interface DLL
        .286P
        .MODEL MEDIUM

        PUBLIC LibEntry     ; Required entry routine
        PUBLIC WEP          ; Required exit routine
        PUBLIC MsDos        ; Call MS-DOS
        PUBLIC SegOf        ; Get segment/selector of a variable
        PUBLIC OfsOf        ; Get offset of a variable

        EXTRN Dos3Call:FAR  ; This is the "hook" into the Windows
                            ; kernel that lets a program call DOS

        .DATA

Filler  db      16 DUP(?)

        .CODE

LibEntry PROC FAR PASCAL; Fall through to code below
LibEntry ENDP

WEP     PROC FAR
        nop          ; Prevent overwriting of the MOV AX,xxxx in
                     ; Real Mode (VB doesn't run in Real Mode, but
                     ;   this may be useful for other languages.)
        mov ax,1     ; Leaf routine, so no prologue or epilogue
        ret
WEP     ENDP

MsDos   PROC FAR
        cld             ; Just to be sure
        inc bp          ; Inc & push bp for the benefit of Windows
        push bp
        push ds         ; Save registers that must be preserved
        push si         ; (Windows DLLs preserve si, di, ds, and bp
        push di         ;   by convention)
        mov bp,sp
        lds si,[bp+12]  ; Parameter address is above original 
                        ; ds+si+di, incremented bp, and return
                        ; address (12 bytes)
        lodsw           ; Get new ax
        push ax         ; Push it while we're using lodsw
        lodsw
        mov bx,ax       ; Get new bx
        lodsw
        mov cx,ax       ; cx
        lodsw
        mov dx,ax       ; dx
        lodsw
        mov bp,ax       ; bp
        lodsw
        push ax         ; Push new si while using lodsw
        lodsw
        mov di,ax       ; Get new di
        lodsw
        push ax         ; Push new ds while using lodsw
        lodsw
        mov es,ax       ; Get new es
        pop ds          ; Retrieve new ds,si,ax
        pop si
        pop ax
        call Dos3Call   ; Call DOS via special Windows API
        pushf           ; Save flags right away
        cld             ; Just to be sure
        push es         ; Save es,di during stosw instructions
        push di
        push bp         ; And bp while finding parameter again
        mov bp,sp       ; Load bp from sp, then account for pushed
        les di,[bp+20]  ; bp, di, es, flags *and* the 12 bytes
                        ; that were there before (18 bytes total)
        stosw           ; Store ax
        mov ax,bx
        stosw           ; bx
        mov ax,cx
        stosw           ; cx
        mov ax,dx
        stosw           ; dx
        pop ax
        stosw           ; bp (from stack)
        mov ax,si
        stosw           ; si
        pop ax
        stosw           ; di (from stack)
        mov ax,ds
        stosw           ; ds
        pop ax
        stosw           ; es (from stack)
        pop ax
        stosw           ; Flags (from stack)
        pop di          ; Restore original registers as required
        pop si
        pop ds
        pop bp
        dec bp          ; Fix up bp
        ret 4           ; Return, popping the address
MsDos   ENDP

SegOf   PROC FAR
        push bp         ; Leaf routine, so just push & restore bp
        mov bp,sp       ;  (no increment/decrement necessary)
        mov ax,[bp+8]   ; Segment of parameter is above return
        pop bp          ; address and the parameter's offset (6
                        ;  bytes up on stack)
        ret 4
SegOf   ENDP

OfsOf   PROC FAR
        push bp         ; Leaf routine, so just push & restore bp
        mov bp,sp       ;  (no increment/decrement necessary)
        mov ax,[bp+6]   ; Offset of parameter is above return
        pop bp          ; address (4 bytes up on stack)
        ret 4
OfsOf   ENDP
        END LibEntry
