PROGRAM XKeyTest;                           { Author: Ron Aaron }
{===============================================================}
{ Tests the low-level keyboard handler provided by the ExtKey   }
{ unit.                                                         }
{ This program is hereby put in the public domain by its author.}
{===============================================================}
USES Crt, App, Objects, Views, Menus, Drivers, Extkey;
CONST cmFilterKeys = 1000;  { Command to turn "duplicate" key...}
                                       {...filtering on or off. }
TYPE
{---------------------------------------------------------------}
{ Make our new application type that understands extended kbd.  }
{---------------------------------------------------------------}
  TMyApplication = Object( TApplication )
    CONSTRUCTOR Init;
    PROCEDURE InitStatusLine; VIRTUAL;
  END;
{---------------------------------------------------------------}
{ Define a TWindow descendent for our test program's output.    }
{---------------------------------------------------------------}
  PMyWindow = ^TMyWindow;
  TMyWindow = Object(TWindow)
    PROCEDURE HandleEvent ( VAR Event : TEvent); VIRTUAL;
  END;

VAR Win : PMyWindow;              { The instance for our window }
{===============================================================}
PROCEDURE TMyWindow.HandleEvent( VAR Event : TEvent );
{---------------------------------------------------------------}
{ Display the type of keyboard and the keycodes for the         }
{ keyboard.  NOTE: Not all extended keys are shown.
{---------------------------------------------------------------}
VAR OutStr : STRING;
    Extra  : STRING;
    Parms  : ARRAY[0..0] OF LongInt;
BEGIN
  CASE Event.What OF
    evKeyDown: BEGIN
      Parms[0] := Event.keycode;
      IF ExtKeyboardInstalled THEN BEGIN
        Extra := '            ';
        FormatStr(OutStr, 'ExtKey: %04X', Parms);
        CASE Event.keycode OF
          kbF12 : OutStr := OutStr +       ' -- F12!    ';
          kbF11 : OutStr := OutStr +       ' -- F11!    ';
          kbCtrlUp : OutStr := OutStr +    ' -- Ctrl+Up!';
          kbPadCtrlUp : OutStr := OutStr + ' Ctrl+PadUp!';
          kbAltUp : OutStr := OutStr +     ' -- Alt+Up! '
          ELSE OutStr := OutStr + Extra;
         END;
        END
      ELSE
        FormatStr(OutStr, 'StdKey: %04X', Parms);
      WriteStr(2,2,OutStr, 1);
    END;
    evCommand: BEGIN
      IF Event.command = cmFilterKeys THEN
        FilterDuplicateKeys := NOT FilterDuplicateKeys;
    END;
  END; {--------------------------------- CASE Event.What OF... }
{---------------------------------------------------------------}
{ Let the standard Window handler do its thing.                 }
{---------------------------------------------------------------}
  TWindow.HandleEvent(Event);
END;
{===============================================================}
CONSTRUCTOR TMyApplication.Init;
{---------------------------------------------------------------}
{ Initialize the application by creating a fixed window that is }
{ slightly smaller than the DeskTop.                            }
{---------------------------------------------------------------}
VAR R : TRect;
BEGIN
  TApplication.Init;
  Desktop^.GetBounds(R);
  R.Grow(-4,-4);
  Win := New(PMyWindow, Init(r, 'Key', 0));
  Win^.Flags := 0;                  { Make this a static window }
  Desktop^.Insert(Win);
END;
{===============================================================}
PROCEDURE TMyApplication.InitStatusLine;
{---------------------------------------------------------------}
{ Define a status line for the Desktop.                         }
{---------------------------------------------------------------}
VAR R : TRect;
BEGIN
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine,Init(R,
                  NewStatusDef(0, $FFFF,
                    NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
                    NewStatusKey('~Shift-F12~ Filter', kbShiftF12,
                                 cmFilterKeys,nil)),nil)));
END;
{===============================================================}
{============== M A I N   P R O G R A M   L O G I C ============}
{===============================================================}
VAR MyApp : TMyApplication;
    Event : TEvent;
BEGIN
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
END.
