
# This is run by MS-DOS perl.exe to handle the -P option.
# The Unix version uses /bin/sed, but MS-DOS doesn't because:
#	1) The system may not have a sed clone.
#	2) Some DOS compilers can't be run as a pure filter.
#	3) A user can alter this script to work with his compiler
#	   and not have to touch the source code for perl.

# This version is Microsoft C 6.0 specific: change as required for
# your compiler.

# Invoked by perl as
#	perl -s this_script [input_file] [-x]

# Input file is STDIN if not listed explicitly.
# Output is to STDOUT.
# -x is given if the perl script was started by -x.

if (!defined($perllib = $ENV{'PERLLIB'})) {
    $perllib = "/usr/local/lib/perl";
}

# Create a temp file name.  It must be in the same directory as the
# script so that #includes work properly.

$tdir = $ARGV[0];

$tdir = "" unless ( $tdir =~ s,(.*[\\/:]).*,$1, );

srand;
do {
    $cppinput = sprintf("${tdir}pcpp%04d.c", rand 10000);
} until ( ! -e $cppinput );

$SIG{'SIGINT'} = 'handler';
open(CPPINPUT, ">$cppinput") || die "Could not open temp file $cppinput";

while (<>) {
    next unless /^#/;
    $x = 0;
    next if/^#\s*include\s/;
    next if/^#\s*define\s/;
    next if/^#\s*undef\s/;
    next if/^#\s*if\s/;
    next if/^#\s*ifdef\s/;
    next if/^#\s*ifndef\s/;
    next if/^#\s*else\s/;
    next if/^#\s*elif\s/;
    next if/^#\s*endif\s/;
    next if/^#\s*pragma\s/;
    next if/^#\s*error\s/;
    $_ = "\n";
}
continue {
	# Work around MSC 6.0's desire to truncate lines at //
	# Won't work for // that are #included, though.
    while ( s,//,/FIX_MSC_SLASH_BUG/,g ) {}
	s,//.*,,;
    print CPPINPUT unless $x;
}

close(CPPINPUT);

$result = system "cl -EP -I$perllib -DFIX_MSC_SLASH_BUG= $cppinput";

unlink $cppinput;

exit $result/256;

sub handler
{
    close(CPPINPUT);
    unlink $cppinput;
}
