(* (c) xTech 1992,93.  All Rights Reserved *)
<*+ M2EXTENSIONS *>
IMPLEMENTATION MODULE InOut;

IMPORT SYSTEM;
IMPORT stdio;
IMPORT string;

TYPE FP = POINTER TO stdio.FILE;

VAR inp,out: FP;

PROCEDURE open(defext-,mode-: ARRAY OF CHAR): FP;
  VAR s: ARRAY [0..127] OF CHAR;
    i,n: CARDINAL;
BEGIN
  IF stdio.printf("filename: ")#0 THEN END;
  ReadString(s);
  IF stdio.printf("\n")#0 THEN END;
  i:=string.strlen(s);
  IF i=0 THEN RETURN NIL END;
  IF s[i-1]="." THEN
    n:=string.strlen(defext);
    IF i+n>=HIGH(s) THEN RETURN NIL END;
    string.strcat(s,defext);
  END;
  RETURN FP( stdio.fopen(s,mode) )
END open;

PROCEDURE OpenInput ( defext-: ARRAY OF CHAR );
BEGIN
  inp:=open(defext,"rt");
  Done:=(inp#NIL);
  IF NOT Done THEN inp:=stdio.stdin END;
END OpenInput;

PROCEDURE OpenOutput( defext-: ARRAY OF CHAR );
BEGIN
  out:=open(defext,"at");
  Done:=(out#NIL);
  IF NOT Done THEN out:=stdio.stdout END;
END OpenOutput;

PROCEDURE CloseInput;
BEGIN
  Done:=stdio.fclose(inp^)=0;
  inp:=stdio.stdin;
END CloseInput;

PROCEDURE CloseOutput;
BEGIN
  Done:=stdio.fclose(out^)=0;
  out:=stdio.stdout;
END CloseOutput;

PROCEDURE Read(VAR v: CHAR);
  VAR i: INTEGER;
BEGIN
  i:=stdio.fgetc(inp^);
  IF i>=0 THEN
    Done:=TRUE; v:=CHR(i);
  ELSE
    Done:=FALSE; v:=0C;
  END;
END Read;

PROCEDURE ReadString(VAR s: ARRAY OF CHAR);
  VAR c: CHAR; i: CARDINAL;
BEGIN
  i:=0;
  LOOP
    Read(c);
    IF NOT Done OR (c<" ") THEN EXIT END;
    IF (c=" ") & (i#0) THEN (* skip space *)
    ELSIF i< HIGH(s) THEN
      s[i]:=c; INC(i);
    END;
  END;
  termCH:=c;
  s[i]:=0C;
END ReadString;

PROCEDURE ReadCard(VAR v: CARDINAL);
  VAR c: CHAR; n,ord: CARDINAL; over: BOOLEAN;
BEGIN
  v:=0;
  REPEAT Read(c) UNTIL NOT Done OR (c#" ");
  IF NOT Done OR (c<"0") OR (c>"9") THEN
    Done:=FALSE; termCH:=c; RETURN
  END;
  n:=0; over:=FALSE;
  WHILE Done & (c>="0") & (c<="9") DO
    ord:=ORD(c)-ORD("0");
    IF n > (MAX(CARDINAL)-ord) DIV 10 THEN
      over:=TRUE;
    ELSE
      n:=n*10+ord;
    END;
    Read(c);
  END;
  termCH:=c;
  IF Done THEN
    Done:=NOT over;
    IF Done THEN v:=n END;
  END;
END ReadCard;

PROCEDURE ReadInt(VAR v : INTEGER);
  VAR c: CHAR; n,ord: CARDINAL; sign,over: BOOLEAN;
BEGIN
  v:=0;
  REPEAT Read(c) UNTIL NOT Done OR (c#" ");
  IF Done THEN
    sign:=(c="-");
    IF sign OR (c="+") THEN Read(c) END;
  END;
  IF NOT Done OR (c<"0") OR (c>"9") THEN
    Done:=FALSE; termCH:=c; RETURN
  END;
  n:=0; over:=FALSE;
  WHILE Done & (c>="0") & (c<="9") DO
    ord:=ORD(c)-ORD("0");
    IF n > (MAX(CARDINAL)-ord) DIV 10 THEN
      over:=TRUE;
    ELSE
      n:=n*10+ord;
    END;
    Read(c);
  END;
  termCH:=c;
  IF Done THEN
    IF over THEN Done:=FALSE;
    ELSIF sign THEN
      IF n<=MAX(INTEGER) THEN v:=-VAL(INTEGER,n)
      ELSIF n=MAX(INTEGER)+1 THEN v:=MIN(INTEGER)
      ELSE Done:=FALSE
      END;
    ELSIF n>MAX(INTEGER) THEN Done:=FALSE
    ELSE v:=n
    END
  END;
END ReadInt;

PROCEDURE Write(c: CHAR);
BEGIN
  Done:=stdio.fputc(INT(c),out^)>=0;
END Write;

PROCEDURE WriteLn;
BEGIN
  Done:=stdio.fprintf(out^,"\n")=1;
END WriteLn;

PROCEDURE WriteString(s-: ARRAY OF CHAR);
  VAR i: CARDINAL;
BEGIN
  i:=0; 
  WHILE (i<=HIGH(s)) & (s[i]#0C) DO
    Done:=stdio.fputc(INT(s[i]),out^)>=0;
    IF NOT Done THEN RETURN END;
    INC(i);
  END;
END WriteString;

PROCEDURE WriteCard(v: CARDINAL ; w: CARDINAL);
BEGIN
  Done:=stdio.fprintf(out^,"%*u",w,v)>0;
END WriteCard;

PROCEDURE WriteInt(v: INTEGER; w: CARDINAL);
BEGIN
  Done:=stdio.fprintf(out^,"%*d",w,v)>0;
END WriteInt;

PROCEDURE WriteOct(v: CARDINAL; w: CARDINAL);
BEGIN
  Done:=stdio.fprintf(out^,"%*o",w,v)>0;
END WriteOct;

PROCEDURE WriteHex(v: CARDINAL; w: CARDINAL);
BEGIN
  Done:=stdio.fprintf(out^,"%*X",w,v)>0;
END WriteHex;

BEGIN
  inp:=stdio.stdin;
  out:=stdio.stdout;
END InOut.
