;		bufs.asm
;========================================================================

; Copyright (C) 1991 by Jan.Engvald@ldc.lu.se, see file COPYING.

BUFBODYSML	equ	2*6+2+28+NBUFSMALM	; optimized for ping length sweep

BUFSIZE 	equ	4*((GIANT+DESCRLEN + 2*16 - 2*EADDR_LEN + SNAPLEN+3)/4)
BUFSIZESML	equ	4*((BUFBODYSML+DESCRLEN+3)/4)

NBUFS		equ	(StackLow-BufStart-NBUFSMALM*BUFSIZESML)/BUFSIZE
NBUFSMALL	equ	(StackLow-BufStart-NBUFS*BUFSIZE)/BUFSIZESML

LinkStruc	struc
dNext		dw	0			; forward link
; dNextSegm	dw	0
dPrev		dw	0			; back link
; dPrevSegm	dw	0
dHomeList	dw	0			; list to release it to
LinkStruc	ends

LinkHead	struc
lNext		dw	0			; forward link
; lNextSegm	dw	0
lPrev		dw	0			; back link
; lPrevSegm	dw	0
lBufsAvail	dw	0			; number of buffers
LinkHead	ends



;************************************************************************
;*		BufAlloc
;*	Output: 	if OK: non-zero and BX = buffer addr
;*					    DI = pkt addr
;*	Destroys:	BX, DI, flags
;************************************************************************

BufAlloc	proc	near
		mov	di,offset FreeBufs	; free buffer chain
		jmp	short BufAl

BufAlSml:
		mov	di,offset FreeSmal
  BufAl:
		call	GetFromList
		jz	BufAllocRet

if DEBUG
		push	ax
		push	cx
		mov	cx,(dPtrDes-dPtrPhys)/2
		lea	di,[bx].dPtrPhys
		mov	ax,0aaaah		; trash old pointers
		rep	stosw
		pop	cx
		pop	ax
endif ; DEBUG
		mov	[bx].dPtrDes,bx 	; fill in descriptor ptrs
		lea	di,[bx].dHwDst
		mov	[bx].dPtrPhys,di	; must be di return value
  BufAllocRet:
		ret
BufAlloc	endp



;************************************************************************
;*		GetFromList
;*	Input:		DI = listhead address
;*	Output: 	if OK: non-zero and BX = buffer addr
;*	Destroys:	BX, flags
;************************************************************************

GetFromList	proc	near
		xor	bx,bx			; ensure zero flag
		PushfDI

		mov	bx,[di].dNext
		cmp	bx,di			; empty list?
		je	BufAlEmpty		; - yes, bad (zero) return

		dec	[di].lBufsAvail 	; number of available bufs

		push	si
		mov	si,[bx].dNext		; - no, link off first buf
		mov	[di].dNext,si
		mov	[si].dPrev,di
		pop	si
if DEBUG
		mov	[bx].dPrev,0
endif ; DEBUG
		PopfEI
		or	bx,bx			; non-zero (OK) return
		ret

  BufAlEmpty:
		PopfEI
		ret
GetFromList	endp



;************************************************************************
;*		BufRelease
;*	Input:		BX = buffer addr
;*	Destroys:	SI, DI (but all flags are saved)
;************************************************************************

BufRelease	proc	near
		mov	si,[bx].dHomeList	; free buffer chain
AddToList:
		pushf
		cli
		mov	di,[si].dPrev		; link in buffer
		mov	[di].dNext,bx		;   at end of chain
		mov	[bx].dPrev,di
		mov	[bx].dNext,si
		mov	[si].dPrev,bx

		inc	[si].lBufsAvail 	; one more buf is now available
		popf
		ret
BufRelease	endp



;************************************************************************
;*		BufInit
;************************************************************************

BufInit 	proc	near
		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	MySegm,ax
		cld

		mov	cx,NBUFS
		mov	bx,offset BufStart
  BufInitLoop:
		mov	[bx].dHomeList,offset FreeBufs
		call	BufRelease
		add	bx,BUFSIZE
		loop	BufInitLoop

		mov	cx,NBUFSMALL
  BufSmlLoop:
		mov	[bx].dHomeList,offset FreeSmal
		call	BufRelease
		add	bx,BUFSIZESML
		loop	BufSmlLoop

		ret
BufInit 	endp

;========================================================================
;		endinclude
